#!/usr/bin/perl
# lun ago  8 14:37:00 CEST 2005
# author: Pedro Larroy Tovar

# This script was used to compress original raw videos to mpeg2
#
#    Copyright (C) Pedro Larroy Tovar piotr%NOSPAMlarroy.com

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


use warnings;
use strict;
use File::Find;
use File::Copy;
use Getopt::Long;
use POSIX;

our $UMASK = 0770;

my $DESTDIR;
my $ORIGDIR;

sub usage {
	die "usage";
}

sub sane_path {
	my $dir = shift;
	$dir =~ s#/{2,}#/#go; # unless ($dir =~ m#://#);
	return $dir;
}

sub mkdir_r {
	my $dir=shift;
	$dir =~ s#/{2,}#/#go;
	my %seen;
	my $current='';
	my @parts=split('/', $dir);
	foreach my $part (@parts) {
	#	next if ! $part;
		$current.="$part/";
		if (! $seen{$current}) {
			if ( ! -d $current ) {
				print "mkdir $current\n";
				mkdir ($current,$UMASK) or die "mkdir $current: $!";
			}
			$seen{$current}=1;
		}
	}
}



sub found {
	my $destdir=$DESTDIR.'/'.$ORIGDIR.'/'.$File::Find::dir;
	my $destfile= $destdir.'/'.$_;
	if ( -f $_ && m/^(.*)\.\Qavi\E$/ ) {
		my $prefix = $1;
		mkdir_r($destdir);
		if ( ! -f $destfile ) {
			my @CMD = ('mencoder','-oac','copy','-ovc','lavc','-lavcopts','vcodec=mpeg2video','-o',$destfile,$_);
			system(@CMD) == 0 or die join(' ',@CMD).": $!";

		} else {
			warn "$destfile exists, skipping\n";
		}
	} elsif ( -f $_ && m/^(.*)\.\Qdat\E$/ ) {
		my $prefix = $1;
		mkdir_r($destdir);
		if ( ! -f $destfile ) {
			copy($_,$destfile) or die "copy: $!";
		} else {
			warn "$destfile exists, skipping\n";
		}
	}
}


if ( @ARGV != 2 ) {
	usage();
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}
$DESTDIR=$ARGV[1];
$ORIGDIR=$ARGV[0];
find(\&found,$ARGV[0]);
