#!/usr/bin/perl
use warnings;
use strict;
use File::Copy;

sub usage {
die<<EOT;
$0 usage:
	$0 dbdirectory
EOT
}

my $prefix = "user";
my $n_prefix = 0;
sub transform {
	my $dir = shift || die;
	print "Entering $dir\n";
	chdir($dir) or die "chdir $dir: $!";
	opendir(ROOTDBDIR,".") or die "opendir .:$!";
	while( my $dentry = readdir(ROOTDBDIR) ) {
		next if ( $dentry =~ m/^\./ ); # hidden file
		if ( -d $dentry ) {
			print "Entering $dentry\n";
			chdir($dentry) or die "chdir $dentry: $!";
			opendir(USERDBDIR,".") or die "opendir .:$!";
			while( my $userdentry = readdir(USERDBDIR) ){
				next if ( $userdentry =~ m/^\./ );
				if ( -f $userdentry && $userdentry =~ m/^([^_\d-]+)/ ) {
					#print "Matched $1  # $userdentry # ".$'."\n";
					my $username = $1;
					my $dest = $prefix;
					$dest .= sprintf("%02d",$n_prefix);
					$dest .= $'; # Rightside of the matched part;
					die "$dest: destination exists, won't overwrite" if (-e $dest);
					print "move($userdentry,$dest)\n";
					move($userdentry,$dest) or die "move $userdentry to $dest: $!";
				}
			
			}
			chdir("..") or die "chdir ..: $!";
			my $dest = $prefix;
			$dest .= sprintf("%02d",$n_prefix);
			print "USERDBDIR: move($dentry,$dest)\n";
			die "$dest: destination exists, won't overwrite" if (-e $dest);
			move($dentry,$dest); #or die "move $dentry to $dest: $!";
			$n_prefix++;
		}
	}
	chdir("..") or die "chdir ..: $!";
}

if ( ! @ARGV ) {
	usage();
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}
if ( @ARGV != 1 ) {
	usage();
}
transform($ARGV[0]);

