// SlidingAnalysis.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "SlidingAnalysis.h"

float (*g_nDPMatrix)[DP_SIZE];


///////////////Dynamic Programming//////////////////////////
void vPrintDPMatrix(short len1, short len2) {

	short i, j;
	FILE *f = fopen("DPMatrix.txt", "wt");
	if (!f)
		return;

//	if (len2 > len1) len1 = len2;
//	if (len1 > len2) len2 = len1;

	for (i = 0; i < len2; i++) {
		for (j = 0; j < len1; j++) {
			fprintf(f, "%7u ", (int)g_nDPMatrix[i][j]);
		}
	fprintf(f, "\n");
	}
	fprintf(f, "\n");
	fclose(f);
}
/////////////////////////////////////////////////////////
float shClsVectDiff(float *vect1, float *vect2)

{
  short i;
  float Dif=0;

  for(i=0; i< VECTOR_SIZE; i++)
		Dif += fabs(vect1[i]-vect2[i]);
  return Dif;
}
/////////////////////////////////////////////////////////
float shClassicDP_Vectors (float *word11,short len1, float *word22, short len2)
{

	float d1, d2, d3, u2, u3, dres; 
	int k, j,i;

    for(i=1; i<4; i++)      
     for(j=1; j<4; j++) 
		 g_nDPMatrix[i][j] = shClsVectDiff(&word11[(i-1) * VECTOR_SIZE],&word22[(j-1) * VECTOR_SIZE]);
	len2--;
	len1--;

     /*  */

     for(k=0; k<(len1); k++)     
	 {
		 for(j=0;j<(len2); j++) 
		 {
             d1 = shClsVectDiff(&word11[(k+1)*VECTOR_SIZE],&word22[(j+1)*VECTOR_SIZE]);
			 d2 =shClsVectDiff(&word11[(k+1)*VECTOR_SIZE],&word22[j*VECTOR_SIZE]);        
			 d3 =shClsVectDiff(&word11[k*VECTOR_SIZE],&word22[(j+1)*VECTOR_SIZE]);
			 dres=g_nDPMatrix[k+1][j]+d2+d1;     /* [k+2][ji+1] */
			 u2=g_nDPMatrix[k+1][j+1]+d1;      /* - */   /* [k+1][ji+1] */
			 u3=g_nDPMatrix[k][j+1]+d3+d1;     /* [k+1][ji+2] */
			 if (dres>u2) dres=u2;
			 if (dres>u3) dres=u3;
			 g_nDPMatrix[k+2][j+2]=dres;
		 }
	 }
	 //vPrintDPMatrix(len1, len2);
	return dres;
}
//////////////////////////////////////////////////////////
float MakeClassicDP_Vectors(float *word11, short len1, float *word22, short len2 )

{
	int i,j;

    for (i = 0; i < len1; i++)
		for (j = 0; j < len2; j++) 
		{
			g_nDPMatrix[i][j] = CONSTA;
			g_nDPMatrix[j][i] = CONSTA;
		}

	float Estim = shClassicDP_Vectors(word11, len1, word22, len2);
	/*
		if (Estim<CONSTA)

		Estim = Estim*100/(len1 + len2);
	*/
	return Estim;
}
//////////////////////////////////////////////////////////
void SlidingStart()
{
	g_nDPMatrix= new float[DP_SIZE][DP_SIZE];
	memset(g_nDPMatrix, 0, DP_SIZE*DP_SIZE*4);
}
//////////////////////////////////////////////////////////
void SlidingFinish()
{
	delete g_nDPMatrix;
}
//////////////////////////////////////////////////////////
int changebytesINT(int input4)
{
	int temp4 = 1;

	memset((char*)&temp4,0,4);
	memcpy((char*)&temp4, (char*)&input4+3, 1);
	memcpy((char*)&temp4+1, (char*)&input4+2, 1);
	memcpy((char*)&temp4+2, (char*)&input4+1, 1);
	memcpy((char*)&temp4+3, (char*)&input4, 1);
	return temp4;
}
//////////////////////////////////////////////////////////
float changebytesFLOAT(float input4)
{
	float temp4 = 1;

	memset((char*)&temp4,0,4);
	memcpy((char*)&temp4, (char*)&input4+3, 1);
	memcpy((char*)&temp4+1, (char*)&input4+2, 1);
	memcpy((char*)&temp4+2, (char*)&input4+1, 1);
	memcpy((char*)&temp4+3, (char*)&input4, 1);
	return temp4;
}
//////////////////////////////////////////////////////////
MFCC_file loadfileMFCC(char* pFileName)
{
	FILE *f;
	int numsamples = 0;
	unsigned long readbytes = 0, ss=0;
	float sample = 0;
	int i, s =0;
	MFCC_file file1;

	//	f = fopen(pFileName, "r");
	HANDLE hFile; 
 
	hFile = CreateFile(pFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	ReadFile(hFile, &numsamples, 4, &readbytes, NULL);

	//fread(&numsamples, 1, 4, f);
	numsamples = changebytesINT(numsamples);

	file1.numsamples = numsamples;
	file1.samples = (float*)malloc(file1.numsamples*4*VECTOR_SIZE);

	ReadFile(hFile, &sample, 4, &readbytes, NULL);
	ReadFile(hFile, &sample, 4, &readbytes, NULL);
	//fread(&sample, 1, 4, f); //header
	//fread(&sample, 1, 4, f); //header

	for (i = 0; i < file1.numsamples*VECTOR_SIZE; i++)
	{
		sample = 0;
		ReadFile(hFile, &sample, 4, &readbytes, NULL);
		ss+=readbytes;
		//s += fread(&sample, 1, 4, f);
		//if feof(f)
		//{
		//	s=11;
		//}
		sample = changebytesFLOAT(sample);
		*(file1.samples + i) = sample;
	}
	
	//fclose(f);
	CloseHandle(hFile);

	return file1;
}
//////////////////////////////////////////////////////////
void clearfiledata(MFCC_file file1)
{
	free(file1.samples);
}
//////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
	int i;
	float data_left1, data_left2, data_right1, data_right2, data_straight1, data_straight2;
	MFCC_file reference_left1;
	MFCC_file reference_left2;
	MFCC_file reference_right1;
	MFCC_file reference_right2;
	MFCC_file reference_straight1;
	MFCC_file reference_straight2;
	MFCC_file speech;
	
	FILE* f;
	char string[100];
	int flagest_left = 0, flagest_right = 0, flagest_straight = 0;;
	int flagtimes_left = 0, flagtimes_right = 0, flagtimes_straight = 0;
	int starttime_left = 0, starttime_right = 0, starttime_straight = 0;
	int minest_left = 10000, minest_right = 10000, minest_straight = 10000;

	/////********************
	SlidingStart();
	/////********************

	if (argc > 1)
	{
		speech = loadfileMFCC(argv[1]);
		if (argc > 2)
		{
			f = fopen(argv[2], "wt");
		}
		else
		{
			f = fopen("result", "wt");
		}
	}
	else
	{
		speech = loadfileMFCC("speech.mfc");
		f = fopen("result", "wt");
	}
	
	reference_left1 = loadfileMFCC("left_real.mfc");
	reference_left2 = loadfileMFCC("left_real2.mfc");
	reference_right1 = loadfileMFCC("right_real.mfc");
	reference_right2 = loadfileMFCC("right_real2.mfc");
	reference_straight1 = loadfileMFCC("straight_real.mfc");
	reference_straight2 = loadfileMFCC("straight_real2.mfc");

	for (i = 0; i < speech.numsamples - reference_left1.numsamples; i=i+5)
	{
		data_left1 = MakeClassicDP_Vectors(reference_left1.samples, reference_left1.numsamples, speech.samples + i*VECTOR_SIZE, reference_left1.numsamples);
		data_left2 = MakeClassicDP_Vectors(reference_left2.samples, reference_left2.numsamples, speech.samples + i*VECTOR_SIZE, reference_left2.numsamples);
		data_right1 = MakeClassicDP_Vectors(reference_right1.samples, reference_right1.numsamples, speech.samples + i*VECTOR_SIZE, reference_right1.numsamples);
		data_right2 = MakeClassicDP_Vectors(reference_right2.samples, reference_right2.numsamples, speech.samples + i*VECTOR_SIZE, reference_right2.numsamples);
		data_straight1 = MakeClassicDP_Vectors(reference_straight1.samples, reference_straight1.numsamples, speech.samples + i*VECTOR_SIZE, reference_straight1.numsamples);
		data_straight2 = MakeClassicDP_Vectors(reference_straight2.samples, reference_straight2.numsamples, speech.samples + i*VECTOR_SIZE, reference_straight2.numsamples);

		if ((data_left1+data_left2) < 4800)
		{
			if (minest_left > (int)(data_left1+data_left2))
			{
				minest_left = (int)(data_left1+data_left2);
				starttime_left = i;
			}
			flagest_left = 1;
			flagtimes_left++;
		}
		else
		{	
			if (flagest_left)
			{
				if (flagtimes_left == 1)
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 LEFT\n", starttime_left, minest_left);
					fwrite(string, strlen(string), 1, f);
				}
				else
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 LEFT\n", starttime_left, minest_left);
					fwrite(string, strlen(string), 1, f);
				}
				flagest_left = 0;
				flagtimes_left = 0;
				minest_left = 10000;
			}
		}

		if ((data_right1+data_right2) < 3800)
		{
			if (minest_right > (int)(data_right1+data_right2))
			{
				minest_right = (int)(data_right1+data_right2);
				starttime_right = i;
			}
			flagest_right = 1;
			flagtimes_right++;
		}
		else
		{	
			if (flagest_right)
			{
				if (flagtimes_right == 1)
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 RIGHT\n", starttime_right, minest_right);
					fwrite(string, strlen(string), 1, f);
				}
				else
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 RIGHT\n", starttime_right, minest_right);
					fwrite(string, strlen(string), 1, f);
				}
				flagest_right = 0;
				flagtimes_right = 0;
				minest_right = 10000;
			}
		}

		if ((data_straight1+data_straight2) < 5400)
		{
			if (minest_straight > (int)(data_straight1+data_straight2))
			{
				minest_straight = (int)(data_straight1+data_straight2);
				starttime_straight = i;
			}
			flagest_straight = 1;
			flagtimes_straight++;
		}
		else
		{	
			if (flagest_straight)
			{
				if (flagtimes_straight == 1)
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 STRAIGHT\n", starttime_straight, minest_straight);
					fwrite(string, strlen(string), 1, f);
				}
				else
				{
					memset(string, 0, 100);
					sprintf(string, "%u00000 STRAIGHT\n", starttime_straight, minest_straight);
					fwrite(string, strlen(string), 1, f);
				}
				flagest_straight = 0;
				flagtimes_straight = 0;
				minest_straight = 10000;
			}
		}
	}
	clearfiledata(reference_left1);
	clearfiledata(reference_left2);
	clearfiledata(reference_right1);
	clearfiledata(reference_right2);
	clearfiledata(reference_straight1);
	clearfiledata(reference_straight2);

	fclose(f);

	clearfiledata(speech);
	/////********************
	SlidingFinish();
	/////********************
	return 0;
}

