#include <stdio.h>
#include <math.h>
#include <string.h>
#include "cv.h"
#include "cxcore.h"
#include "highgui.h"

static const double pi = 3.14159265358979323846;
IplImage* img=NULL;
IplImage* cap=NULL;
IplImage* img1=NULL;
IplImage* img2=NULL;


IplImage* img_yuv=NULL;
IplImage* img_blob=NULL;
IplImage* img_mask=NULL;
IplImage* img_contour=NULL;
CvCapture* video = NULL;
typedef struct ellipse
{
    CvPoint center;  /* center of the box */
    CvSize  size;    /* box width and length */
    float angle;          /* angle between the horizontal axis
                             and the first side (i.e. length) in radians */
}
ellipse;
inline static void allocateOnDemand( IplImage **img, CvSize size, int depth, int channels)
{
	if ( *img != NULL ) return;
	*img = cvCreateImage( size, depth, channels );
	if ( *img == NULL )
	{
		fprintf(stderr, "Error: Couldn't allocate image. Out of memory?\n");
		exit(-1);
	}
}

void getIplPixel(IplImage *img, int x, int y, unsigned char *values){
		for (int i=0; i<img->nChannels; i++)
			values[i] = (unsigned char)img->imageData[(y*img->width + x)*img->nChannels + i];
}




int main(void)
{
	double mean[2]={0};
	double covariance[2][2]={0};	
	char option=0;
	FILE* pFile;
	//pFile=fopen("statistics.bin","rb");
	//fread(mean,sizeof(double),2,pFile);
	//fread(covariance[0],sizeof(double),2,pFile);
	//fread(covariance[1],sizeof(double),2,pFile);
	//fclose(pFile);
	cvNamedWindow("Test",1);
	CvMemStorage* storage = 0;
	storage = cvCreateMemStorage(0);
	CvHaarClassifierCascade* cascade = 0;
	cascade = cvLoadHaarClassifierCascade("hand_classifier_take_1",cvSize(20,15));

	
	ellipse search_window;
	ellipse head;
	
	
	video = cvCaptureFromFile( "d:/db/enterface_small.avi");
	//video = cvCaptureFromFile( "d:/db/deneme.avi");
	//video = cvCaptureFromFile( "d:/frames/Cam1_T000009.880_T000508.520.avi");
	
	cap = cvQueryFrame( video );
	
	
	img=cvCloneImage(cap);
	img1=cvCreateImage(cvGetSize(cap),IPL_DEPTH_8U,1);
	img2=cvCreateImage(cvGetSize(cap),IPL_DEPTH_8U,1);
	
	




	int width=cvGetCaptureProperty(video,CV_CAP_PROP_FRAME_WIDTH );
	int height=cvGetCaptureProperty(video,CV_CAP_PROP_FRAME_HEIGHT );
	
	img_yuv=cvCloneImage(img);
	img_blob=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
	img_mask=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
	img_contour=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
	

	
	cvFlip(img,img); img->origin=0;
	cvCvtColor( img , img1, CV_BGR2GRAY );
	
	
	CvSeq* hands=cvHaarDetectObjects(img,cascade,storage,1.1,2,CV_HAAR_DO_CANNY_PRUNING,cvSize(20,15));
	
	for(int i=0;i<hands->total;i++)
	{
		CvRect* r = (CvRect*)cvGetSeqElem( hands, i);

		search_window.angle=0;			
		search_window.center=cvPoint(r->x+(r->width)/2,r->y+(r->height)/2);
		search_window.size=cvSize((r->width)/2+10,(r->height)/2+10);
		//cvEllipse(img,search_window.center,search_window.size,search_window.angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);	
		

		
		head.angle=0;			
		head.center=cvPoint(r->x+(r->width)/2,r->y+(r->height)/2);
		head.size=cvSize((r->width)/2,(r->height)/2+10);
		//if ( sqrt((double) r->height*r->height + r->width*r->width) < 60  )
		
		int count =0;
		for (int h=r->y; h<(r->y+r->height); h++) 
		{
			for (int w=r->x; w<(r->x+r->width); w++) 
			{
				unsigned char values[3];
				getIplPixel(img, w, h, values);
				
				// convert to YCRCB
				int B = values[0];
				int G = values[1];
				int R = values[2];
				int Y = 0.299*R + 0.587*G + 0.114*B;
				int Cr = (R-Y)*0.713 + 128;
				int Cb = (B-Y)*0.564 + 128;
				if ((Cb<=120) && (Cb>=110) && (Cr<=155) && (Cr>=140)){
				//if ((Cb<=127) && (Cb>=77) && (Cr<=173) && (Cr>=133)){
					count++;
				}
			}
		}
		
		
		
		
		
		if ((count/(1.0 * r->width * r->height)) > 0.09)
			cvRectangle(img,cvPoint(r->x,r->y),cvPoint(r->x+r->width,r->y+r->height), CV_RGB(0,255,0),1,8,0 );
		else
			cvRectangle(img,cvPoint(r->x,r->y),cvPoint(r->x+r->width,r->y+r->height), CV_RGB(255,0,0),1,8,0 );


		
		//cvEllipse(img,head.center,head.size,head.angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);
		//printf("%d \t %d,%d\n",i,r->width,r->height);
	}
	cvShowImage("Test",img);cvWaitKey(0);
	img=cvCloneImage(cap);
	cvFlip(img,img); img->origin=0;
	
	
	for (int i=0;i<cvGetCaptureProperty(video,CV_CAP_PROP_FRAME_COUNT)-1;i++)
	{
		
		cap = cvQueryFrame( video );		
		cvCvtColor(cap,img2, CV_BGR2GRAY );
		cvFlip(img2,NULL,0); img2->origin=0;
		cvCvtColor(img,img_yuv,CV_RGB2YCrCb);
			CvSeq* hands=cvHaarDetectObjects(img,cascade,storage,1.1,2,CV_HAAR_DO_CANNY_PRUNING,cvSize(20,15));
	
		for(int i=0;i<hands->total;i++)
		{
			CvRect* r = (CvRect*)cvGetSeqElem( hands, i);

			search_window.angle=0;			
			search_window.center=cvPoint(r->x+(r->width)/2,r->y+(r->height)/2);
			search_window.size=cvSize((r->width)/2+10,(r->height)/2+10);
			//cvEllipse(img,search_window.center,search_window.size,search_window.angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);	
			

			
			head.angle=0;			
			head.center=cvPoint(r->x+(r->width)/2,r->y+(r->height)/2);
			head.size=cvSize((r->width)/2,(r->height)/2+10);
			if ( sqrt((double) r->height*r->height + r->width*r->width) < 60  )
				cvEllipse(img,head.center,head.size,head.angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);
			//printf("%d \t %d,%d\n",i,r->width,r->height);
		}
		cvShowImage("Test",img);cvWaitKey(10);
		cvReleaseImage(&img);
		img=cvCloneImage(cap);
		cvFlip(img,img); img->origin=0;
		cvCvtColor( img , img1, CV_BGR2GRAY );

	}

	return 0;


}
