#include <stdio.h>
#include <math.h>
#include "cv.h"
#include "highgui.h"
#include "cxcore.h"

#define draw_cross( center, color, d )                                 \
    cvLine( img, cvPoint( center.x - d, center.y - d ),                \
                    cvPoint( center.x + d, center.y + d ), color, 1, 0 ); \
    cvLine( img, cvPoint( center.x + d, center.y - d ),                \
                    cvPoint( center.x - d, center.y + d ), color, 1, 0 )

IplImage* img=NULL;
IplImage* cap=NULL;
IplImage* img1=NULL;
IplImage* img2=NULL;
IplImage* img_yuv=NULL;
IplImage* img_mask=NULL;
IplImage* img_contour=NULL;
CvCapture* video = NULL;
CvPoint center;

void resize_image()
{
	IplImage* temp = cvCreateImage(cvSize(img->width/2,img->height/2),IPL_DEPTH_8U,3);
	cvPyrDown( img, temp, CV_GAUSSIAN_5x5 );
	cvReleaseImage(&img);
	img = temp;
}


void on_mouse( int event,int a,int  b, int flags )
{
	if (event == 1)
	{
		center.x=a;
		center.y=b;
	}
}

bool check(int i,int j , double mean[2] , double covariance [2][2])
{
	int x=(int)((uchar*)(img_yuv->imageData + img_yuv->widthStep*i))[3*j+1];
	int y=(int)((uchar*)(img_yuv->imageData + img_yuv->widthStep*i))[3*j+2];
	double exponent = (double) -0.5 * (pow(x-mean[0],2)/covariance[0][0]+pow(y-mean[1],2)/covariance[1][1]);
	if (exponent>-1.5)
		return true;
		//((uchar*)(img_blob->imageData + img_blob->widthStep*i))[j]=255;
	else
		return false;
		//((uchar*)(img_blob->imageData + img_blob->widthStep*i))[j]=0;	
	
	
	
	//if ( x >= 110 && x <= 120 && y >=140 && y<=155 )
	//	return true;
	//else
	//	return false;
}


int main(void)
{
	
	//FILE* output = fopen ("c:/output.txt","wt");
    /* A matrix data */
	
	CvFont font;

	cvInitFont( &font, CV_FONT_HERSHEY_COMPLEX, 0.5, 0.5, 0.0, 1, CV_AA );


	
	double mean[2]={0};
	double covariance[2][2]={0};
	FILE* pFile;
	pFile=fopen("statistics.bin","rb");
	fread(mean,sizeof(double),2,pFile);
	fread(covariance[0],sizeof(double),2,pFile);
	fread(covariance[1],sizeof(double),2,pFile);
	fclose(pFile);

	float A[4][4]={0};
	A[0][0]=1;A[0][2]=(float)1/25;
	A[1][1]=1;A[1][3]=(float)1/25;
	A[2][2]=1;
	A[3][3]=1;
	float H[2][4]={0};
	H[0][0]=1;
	H[1][1]=1;
	float B[4][4]={0};
	B[0][0]=5;
	B[1][1]=5;
	B[2][2]=10;
	B[3][3]=10;
    CvKalman* kalman_left = cvCreateKalman( 4, 2 , 0 );
	CvKalman* kalman_right = cvCreateKalman( 4, 2 , 0 );
    
	
	CvMat* state = cvCreateMat( 2, 1, CV_32FC1 );
    CvMat* process_noise = cvCreateMat( 4, 1, CV_32FC1 );
    CvMat* measurement = cvCreateMat( 2, 1, CV_32FC1 );
	CvMat* measurement_noise = cvCreateMat( 2, 1, CV_32FC1 );

    cvZero( measurement );
    cvNamedWindow( "Test", 1 );

    memcpy( kalman_left->transition_matrix->data.fl, A, sizeof(A));
	memcpy( kalman_left->measurement_matrix->data.fl, H, sizeof(H));
	memcpy( kalman_left->process_noise_cov->data.fl, B, sizeof(B));
    
	memcpy( kalman_right->transition_matrix->data.fl, A, sizeof(A));
	memcpy( kalman_right->measurement_matrix->data.fl, H, sizeof(H));
	memcpy( kalman_right->process_noise_cov->data.fl, B, sizeof(B));
	
	
	
	//CvMemStorage* storage = 0;
	//storage = cvCreateMemStorage(0);
	//CvHaarClassifierCascade* cascade = 0;
	//CvHaarClassifierCascade* cascade = (CvHaarClassifierCascade*)cvLoad("deneme.xml", 0, 0, 0 );
	//CvHaarClassifierCascade* cascade = (CvHaarClassifierCascade*) cvLoad( "deneme.xml" );
	CvHaarClassifierCascade* cascade = cvLoadHaarClassifierCascade( "tree", cvSize(20,20) );
	//cvSave( "deneme.xml", cascade_old );
	
	
	
	
	CvPoint left_hand,right_hand;

	FILE* video_list = fopen ( "c:/videos/list.txt"  ,"r");
	char video_name[100];
	while (!feof(video_list))
	{

		char video_name_temp[50];
		fscanf(video_list,"%s",video_name_temp);
		strcpy (video_name,"c:/videos/");
		strcat(video_name,video_name_temp);

	
		


	

		char feature_name[100]=" ";
		for (int i=0;video_name[i] != '.' ;i++)
 			feature_name[i]=video_name[i];
		strcat (feature_name,".txt");
		printf("%s\n",feature_name);
		
		
		
		FILE* feature_out = fopen (feature_name,"w");
	
		video = cvCaptureFromFile(video_name);
	
		//video = cvCaptureFromFile( "c:/video3s.avi");
		//video = cvCaptureFromFile( "d:/db/enterface_small.avi");
		//video = cvCaptureFromFile( "d:/db/deneme.avi");
		//video = cvCaptureFromFile( "d:/frames/Cam1_T000009.880_T000508.520.avi");
		
		cap = cvQueryFrame( video );	
		img=cvCloneImage(cap);
		cvFlip(img,img); img->origin=0;
		resize_image();
		img_yuv=cvCloneImage(img);
		cvCvtColor(img,img_yuv,CV_RGB2YCrCb);
		


		//CvMemStorage* storage = 0;
		//storage = cvCreateMemStorage(0);
		//CvSeq* hands=cvHaarDetectObjects(img,cascade,storage,1.1,2,0,cvSize(20,20));
		//CvSeq* skin_region;
		//skin_region = cvCreateSeq(CV_SEQ_ELTYPE_POINT, sizeof(CvSeq), sizeof(CvPoint) , storage);

		//CvSeq* real_hands;
		//real_hands = cvCreateSeq(CV_SEQ_ELTYPE_POINT, sizeof(CvSeq), sizeof(CvPoint) , storage);


		img_mask = cvCreateImage( cvGetSize(img), IPL_DEPTH_8U , 1 );
		img_contour = cvCreateImage( cvGetSize(img), IPL_DEPTH_8U , 1 );
		for (int i=0;i<img->height;i++){
			for ( int j=0;j<img->width;j++)
			{
				if ( check(i,j,mean,covariance) )
				{

					//img->imageData[(i*img->widthStep) + j*3] = 255;
					//img->imageData[(i*img->widthStep) + j*3+1 ] = 0;
					//img->imageData[(i*img->widthStep) + j*3+2 ] = 0;
					img_mask->imageData[(i*img_mask->widthStep) + j ] = 255;

					//cvSeqPush( skin_region, &cvPoint(j,i));
					//fprintf(feature_out,"%d %d\n",i,j);
				}
			}
		}



	cvShowImage("Test",img_mask);cvWaitKey(0);










	//cvCanny( img_mask, img_contour, 100,200,3 );

	//cvShowImage("Test",img_contour);cvWaitKey(0);

    CvMemStorage* stor;
	//CvMemStorage* temp = NULL;
    CvSeq* cont;
	CvSeq* real_hands;
	
	
	//CvSeq* maxcont;
	//CvBox2D32f boxRect;
    //CvPoint* PointArray;
    //CvPoint2D32f* PointArray2D32f;    
    // Create dynamic structure and sequence.
    stor = cvCreateMemStorage(0);
    cont = cvCreateSeq(CV_SEQ_ELTYPE_POINT, sizeof(CvSeq), sizeof(CvPoint) , stor); 
	real_hands = cvCreateSeq(CV_SEQ_ELTYPE_POINT, sizeof(CvSeq), sizeof(CvPoint) , stor);
	//cvThreshold( img_mask, img_contour , 125 , 255, CV_THRESH_BINARY );
    // Find all contours.
    cvFindContours( img_mask, stor, &cont, sizeof(CvContour),CV_RETR_LIST, CV_CHAIN_APPROX_NONE, cvPoint(0,0));
    

        for( ; cont != 0; cont = cont->h_next )
        {
			//printf("%d\n",cont->total);
            //CvScalar color = CV_RGB( rand()&255, rand()&255, rand()&255 );
            /* replace CV_FILLED with 1 to see the outlines */
            //if (  cont->total >20 &&  cont->total<250 )
			double area = fabs(cvContourArea(cont));

			//printf("%f\n",area);
			if ( area >100 && area < 1000)
			{
				//cvDrawContours( img, cont, CV_RGB(255,0,0), CV_RGB(255,0,0), -1, 1/*CV_FILLED*/, 8 );
				CvPoint* PointArray = (CvPoint*)malloc( cont->total*sizeof(CvPoint) );
				cvCvtSeqToArray(cont, PointArray, CV_WHOLE_SEQ);
				int hand_x=0;int hand_y=0;
				for (int i=0;i<cont->total;i++)
				{
					hand_x=hand_x+PointArray[i].x;
					hand_y=hand_y+PointArray[i].y;
				}
				cvSeqPush( real_hands, &cvPoint(cvRound((double)hand_x/cont->total),cvRound((double)hand_y/cont->total)));



			}
        }
		CvPoint* hand = (CvPoint*)cvGetSeqElem( real_hands, 0);			
		left_hand = *hand;
		hand = (CvPoint*)cvGetSeqElem( real_hands, 1);
		if (left_hand.x <= hand->x)
		{			
			right_hand = *hand;
		}
		else
		{
			right_hand = left_hand;
			left_hand = *hand;
		}
		//cvCircle( img, cvPoint(185,212),5,CV_RGB(0,255,0),-1,8,0);
		cvCircle( img, left_hand,5,CV_RGB(0,255,0),-1,8,0);
		cvCircle( img, right_hand,5,CV_RGB(255,0,0),-1,8,0);
		cvShowImage("Test",img);
		if ( cvWaitKey (0) != 32 )
		{
			printf("Click on Left Hand\n");
			cvSetMouseCallback( "Test", on_mouse );cvWaitKey(0);
			left_hand=center;
			printf("Ok. Left hand is located at %d,%d\n",left_hand.x,left_hand.y);
			printf("Click on Right Hand\n");
			cvSetMouseCallback( "Test", on_mouse );cvWaitKey(0);
			right_hand=center;
			printf("Ok. Right hand is located at %d,%d\n",right_hand.x,right_hand.y);
		}
		
		cvReleaseMemStorage(&stor);
	
		
		
		
		//cvSetIdentity( kalman_left->measurement_matrix, cvRealScalar(1) );
		//cvSetIdentity( kalman_left->process_noise_cov, cvRealScalar(10) );

		//cvSetReal2D( kalman_left->process_noise_cov,1,1,(double) 1 );
		
		cvSetIdentity( kalman_left->measurement_noise_cov, cvRealScalar(3) );
		cvSetIdentity( kalman_left->error_cov_post, cvRealScalar(1));
	   

		//cvSetIdentity( kalman_right->measurement_matrix, cvRealScalar(1) );
		//cvSetIdentity( kalman_right->process_noise_cov, cvRealScalar(10) );
		cvSetIdentity( kalman_right->measurement_noise_cov, cvRealScalar(3) );
		cvSetIdentity( kalman_right->error_cov_post, cvRealScalar(1));	
		
		
		cvSetReal1D(kalman_left->state_post,0,(double)left_hand.x);
		cvSetReal1D(kalman_left->state_post,1,(double)left_hand.y);
		cvSetReal1D(kalman_left->state_post,2,(double)0);
		cvSetReal1D(kalman_left->state_post,3,(double)0);
		
		cvSetReal1D(kalman_right->state_post,0,(double)right_hand.x);
		cvSetReal1D(kalman_right->state_post,1,(double)right_hand.y);
		cvSetReal1D(kalman_right->state_post,2,(double)0);
		cvSetReal1D(kalman_right->state_post,3,(double)0);
		
		
		
		//CvPoint predict_pt_left;
		//CvPoint predict_pt_right;
		
		//CvVideoWriter* video_out = cvCreateVideoWriter( "c:/kalman.avi",-1,25.0, cvGetSize(cap) );
		

		cvReleaseImage(&img);
		img=cvCloneImage(cap);
		cvFlip(img,img); img->origin=0;
		resize_image();
		img_yuv=cvCloneImage(img);
		cvCvtColor(img,img_yuv,CV_RGB2YCrCb);

		int count=0;
		int sum_x=0;
		int sum_y=0;



		const CvMat* prediction_left = cvKalmanPredict( kalman_left, 0 );
		left_hand = cvPoint(prediction_left->data.fl[0],prediction_left->data.fl[1]);
		for (int i=0;i<cvGetCaptureProperty(video,CV_CAP_PROP_FRAME_COUNT)-1;i++)
		{
			cvCvtColor(img,img_yuv,CV_RGB2YCrCb);
			//cvCvtColor(img,img_mask,CV_RGB2GRAY);
			//cvCanny( img_mask, img_contour, 100,200,3 );
			//cvShowImage("Test",img_contour);cvWaitKey(0);
			//CvMemStorage* storage = 0;
			//storage = cvCreateMemStorage(0);
			//CvHaarClassifierCascade* cascade = 0;

			//cascade = (CvHaarClassifierCascade*)cvLoad("haarcascade_frontalface_default.xml", 0, 0, 0 );
			//CvSeq* faces=cvHaarDetectObjects(img,cascade,storage,1.1,2,CV_HAAR_DO_CANNY_PRUNING,cvSize(40,40));
			//
			//for (int g = 0 ; g < faces->total ; g++ )
			//{
			//
			//	CvRect* rFace = (CvRect*)cvGetSeqElem( faces, 0 );
			//	CvPoint center = cvPoint(rFace->x+(rFace->width)/2,rFace->y+(rFace->height)/2);
			//	CvSize size = cvSize((rFace->width)/2,(rFace->height)/2+10);
			//	cvEllipse(img_yuv,center,size,0,0,360,CV_RGB(0,0,0),-1,CV_AA,0);	

			//}
			//printf("Number of faces found: %d\n", faces->total);
			//int numfaces = faces->total;
			//if (numfaces > 0){
			//	head_search_window->angle=0;			
			//	head_search_window->center=cvPoint(rFace->x+(rFace->width)/2,rFace->y+(rFace->height)/2);
			//	head_search_window->size=cvSize((rFace->width)/2+10,(rFace->height)/2+10);
			//	//cvEllipse(img,head_search_window.center,head_search_window.size,head_search_window.angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);	
			//
			//	head->angle=0;			
			//	head->center=cvPoint(rFace->x+(rFace->width)/2,rFace->y+(rFace->height)/2);
			//	head->size=cvSize((rFace->width)/2,(rFace->height)/2+10);
			//	cvEllipse(img,head->center,head->size,head->angle,0,360,CV_RGB(255,0,0),3,CV_AA,0);				
			//}
			//cvReleaseHaarClassifierCascade( &cascade );
			//cvReleaseMemStorage(&storage);
			
			const CvMat* prediction_left = cvKalmanPredict( kalman_left, 0 );
			//left_hand = cvPoint(prediction_left->data.fl[0],prediction_left->data.fl[1]);			
			count=0;sum_x=0;sum_y=0;
			for (int i=left_hand.y-15;i<left_hand.y+25;i++)
				for (int j=left_hand.x-10;j<left_hand.x+10;j++)
					if (i>=0 && i < img->height && j>=0 && j < img->width )
						if ( check(i,j,mean,covariance) )
							{sum_x=sum_x+j;sum_y=sum_y+i;count++;}

			left_hand.x=cvRound((float)sum_x/(float)count);
			left_hand.y=cvRound((float)sum_y/(float)count);
			printf("%d\n",count);
			//predict_pt_left = cvPoint(prediction_left->data.fl[0],prediction_left->data.fl[1]);
			measurement->data.fl[0]=left_hand.x;
			measurement->data.fl[1]=left_hand.y;
			cvKalmanCorrect(kalman_left,measurement);
			//draw_cross(center,CV_RGB(255,0,0),10);
			//draw_cross(predict_pt,CV_RGB(0,255,0),10);
			//cvCircle( img,cvPoint(cvGetReal1D(kalman_left->state_post,0),cvGetReal1D(kalman_left->state_post,1)),5,CV_RGB(0,255,0),-1,8,0);
			
			cvCircle( img,left_hand,5,CV_RGB(0,255,0),-1,8,0);
			//cvCircle( img,cvPoint(prediction_left->data.fl[0],prediction_left->data.fl[1]),5,CV_RGB(255,255,0),-1,8,0);
			
			//cvWriteFrame( video_out, img );
			


			count=0;sum_x=0;sum_y=0;
			
			const CvMat* prediction_right = cvKalmanPredict( kalman_right, 0 );
			//right_hand = cvPoint(prediction_right->data.fl[0],prediction_right->data.fl[1]);
			
			printf("Give right hand position\n");
			cvShowImage("Test",img);
			cvSetMouseCallback( "Test", on_mouse );cvWaitKey(0);
			right_hand=center;			
			for (int i=right_hand.y-15;i<right_hand.y+25;i++)
				for (int j=right_hand.x-10;j<right_hand.x+10;j++)
					if (i>=0 && i < img->height && j>=0 && j < img->width )
						if ( check(i,j,mean,covariance) )
						{sum_x=sum_x+j;sum_y=sum_y+i;count++;}
			right_hand.x=cvRound((float)sum_x/(float)count);
			right_hand.y=cvRound((float)sum_y/(float)count);
			
			//predict_pt_right = cvPoint(prediction_right->data.fl[0],prediction_right->data.fl[1]);
			measurement->data.fl[0]=right_hand.x;
			measurement->data.fl[1]=right_hand.y;
			cvKalmanCorrect(kalman_right,measurement);
			//draw_cross(center,CV_RGB(255,0,0),10);
			//draw_cross(predict_pt,CV_RGB(0,255,0),10);
			//cvCircle( img, cvPoint(cvGetReal1D(kalman_right->state_post,0),cvGetReal1D(kalman_right->state_post,1)),5,CV_RGB(255,0,0),-1,8,0);
			cvCircle( img, right_hand,5,CV_RGB(255,0,0),-1,8,0);
			cvPutText( img,video_name,cvPoint(20,20), &font, CV_RGB(0,0,0) );
			cvShowImage("Test",img);		
			cvReleaseImage(&img);


			cap = cvQueryFrame( video );
			img=cvCloneImage(cap);
			cvFlip(img,img); img->origin=0;
			resize_image();
			//cvCvtColor( img , img1, CV_BGR2GRAY );
			//fprintf(output,"%d,%d\n",predict_pt_left.x,predict_pt_left.y);
			fprintf(feature_out,"%f %f %f %f %f %f %f %f\n",
				cvGetReal1D(kalman_left->state_post,0),
				cvGetReal1D(kalman_left->state_post,1),
				cvGetReal1D(kalman_left->state_post,2),
				cvGetReal1D(kalman_left->state_post,3),
				cvGetReal1D(kalman_right->state_post,0),
				cvGetReal1D(kalman_right->state_post,1),
				cvGetReal1D(kalman_right->state_post,2),
				cvGetReal1D(kalman_right->state_post,3));
			//cvWaitKey(0);
		}
	
		cvWaitKey(0);
		cvReleaseImage(&img);
		cvReleaseImage(&img_yuv);
		fclose(feature_out);


		cvReleaseCapture( &video );
		//cvReleaseVideoWriter( &video_out);
	}
	
	
	cvReleaseHaarClassifierCascade( &cascade );
	fclose(video_list);

    return 0;
}
