
#include <stdio.h>
#include <math.h>
#include "cv.h"
#include "highgui.h"
#include "cxcore.h"

#define body_color CV_RGB(255,255,255)
#define head_color CV_RGB(157,93,83)
#define hand_color CV_RGB(157,93,83)



IplImage* img = NULL;
CvPoint head           = cvPoint (360/2,200/2 );
CvPoint left_shoulder  = cvPoint (279/2,287/2 );
CvPoint left_elbow	   = cvPoint (230/2,410/2 );
CvPoint left_hand      = cvPoint (293/2,525/2 );
CvPoint left_hand_org      = cvPoint (293/2,525/2 );
CvPoint right_shoulder = cvPoint (437/2,276/2 );
CvPoint right_elbow    = cvPoint (497/2,412/2 );
CvPoint right_hand     = cvPoint (393/2,500/2 );
CvPoint right_hand_org     = cvPoint (393/2,500/2 );
CvPoint lower_body     = cvPoint (357/2,432/2 );

void draw_segment(CvPoint pt1,CvPoint pt2)
{
	cvCircle(img,pt1,10/2,body_color,-1,CV_AA,0 );
	cvLine(img,pt1,pt2,body_color,10/2,CV_AA,0);
	cvCircle(img,pt2,10/2,body_color,-1,CV_AA,0 );
}
void draw_body()
{
	draw_segment(left_shoulder,left_elbow);
	draw_segment(left_elbow,left_hand);
	draw_segment(left_shoulder,right_shoulder);
	draw_segment(right_shoulder,right_elbow);
	draw_segment(right_elbow,right_hand);
	draw_segment(head,cvPoint(cvRound((right_shoulder.x+left_shoulder.x)/2),cvRound((right_shoulder.y+left_shoulder.y)/2)));
	draw_segment(lower_body,cvPoint(cvRound((right_shoulder.x+left_shoulder.x)/2),cvRound((right_shoulder.y+left_shoulder.y)/2)));
}
void draw_head()
{
	cvEllipse(img,head,cvSize(40/2,55/2),0,0,360,head_color,-1,CV_AA,0);
}

void draw_hands()
{
	cvEllipse(img,left_hand,cvSize(30/2,30/2),0,0,360,hand_color,-1,CV_AA,0);
	cvEllipse(img,right_hand,cvSize(30/2,30/2),0,0,360,hand_color,-1,CV_AA,0);
}
void draw()
{
	cvZero(img);
	draw_body();
	draw_head();
	draw_hands();
}


int get_number_of_lines(char* name)
{
	FILE* input = fopen(name,"r");
	char temp[100];double a=0,b,prev;
	fscanf (input, "%s", temp);
	fscanf (input, "%s", temp);
	int keyword_count=0;
	while (true)
	{
		prev=a;
		fscanf (input, "%lf", &a);

		if (prev == a)
			break;
		else
		{
			fscanf (input, "%lf", &b);
			fscanf (input, "%s", temp);	
			keyword_count++;
		}
	}
	fclose(input);
	return keyword_count;

}

void get_start_instants(char* name,int num_keywords,int* keyword_start)
{
	FILE* input = fopen(name,"r");
	char temp[100];double a=0,b,prev;
	fscanf (input, "%s", temp);
	fscanf (input, "%s", temp);
	for(int i=0;i<num_keywords;i++)
	{
		prev=a;
		fscanf (input, "%lf", &a);
		keyword_start[i]=cvRound(a*25/1e7);
		fscanf (input, "%lf", &b);
		fscanf (input, "%s", temp);	
	}
	fclose(input);
}

void get_trajectory(int keyword_count,int* keyword_duration,
					int** left_hand_trajectory_x,int** left_hand_trajectory_y,
					int** right_hand_trajectory_x,int** right_hand_trajectory_y)
{

	for (int i=0;i<keyword_count;i++)
	{
		int duration,temp;

		char name[10];
		itoa (i,name,10);
		strcat (name,".dat");
		printf("%s\n",name);
		FILE* input = fopen(name,"r");
		fscanf (input, "%d", &duration);

		fscanf (input, "%d %d %d", &temp,&temp,&temp);
		
		
		keyword_duration[i]=duration;
		left_hand_trajectory_x[i]=new int[duration];
		left_hand_trajectory_y[i]=new int[duration];
		right_hand_trajectory_x[i]=new int[duration];
		right_hand_trajectory_y[i]=new int[duration];
		for (int j=0;j<duration;j++)
		{

			fscanf (input, "%d", &right_hand_trajectory_x[i][j]);
			fscanf (input, "%d", &right_hand_trajectory_y[i][j]);

			fscanf (input, "%d", &left_hand_trajectory_x[i][j]);
			fscanf (input, "%d", &left_hand_trajectory_y[i][j]);

		}
		fclose(input);	
	}
}

int main (void)
{
	FILE* input = fopen("head_mov_time.dat","rb");
	fseek (input , 0 , SEEK_END);
	int head_size = ftell (input);
	head_size=head_size/8;
	rewind (input);
	int** accents = new int*[head_size];
	for (int i=0;i<head_size;i++)
		accents[i]=new int[2];


	for (int i=0;i<head_size;i++)
		fread(accents[i],sizeof(int),2,input);
	fclose(input);	
	int keyword_count=get_number_of_lines("recout_short");
	int* keyword_start= new int[keyword_count];
	get_start_instants("recout_short",keyword_count,keyword_start);
	
	int* keyword_duration= new int[keyword_count];
	int** left_hand_trajectory_x= new int*[keyword_count];
	int** left_hand_trajectory_y= new int*[keyword_count];
	int** right_hand_trajectory_x= new int*[keyword_count];
	int** right_hand_trajectory_y= new int*[keyword_count];
	get_trajectory(keyword_count,keyword_duration,left_hand_trajectory_x,left_hand_trajectory_y,
		right_hand_trajectory_x,right_hand_trajectory_y);
	
	

	for(int i=0;i<keyword_duration[0];i++)
		printf("%d,%d\n",left_hand_trajectory_x[0][i],left_hand_trajectory_y[0][i]);



	FILE* pfile = fopen("start_frames.txt","w");
	for(int i=0;i<keyword_count;i++)
		fprintf(pfile,"%d\n",keyword_start[i]);
	fclose(pfile);
	
	
	
	
	
	
	
	
	img = cvCreateImage( cvSize(720/2,576/2), IPL_DEPTH_8U , 3 );
	

	CvVideoWriter* video_out = cvCreateVideoWriter( "c:/deneme2.avi",-1,25.0, cvGetSize(img) );


	

	cvZero(img);
	draw();




	cvNamedWindow("Test",1);

	//cvSet(img1,cvScalar(255,255,255));
	cvShowImage("Test",img);cvWaitKey(0);


	//for (int i=1;i<10;i++)
	//{
	//	printf("%d,%d\n",accents[i][0],accents[i][1]);
	//
	//}
	int head_count=0;
	int hand_count=0;
	int duration=0;
	int hand_duration=0;
	int down_up;
	bool head_state=false;
	bool hand_state=false;
	printf("///////\n");
	//CvPoint head = cvPoint (100,100);
	for (int i=0;i<8248;i++)
	{

		cvZero(img);
		if (head_count<head_size)
		if (i==accents[head_count][0])
		{
			printf("%f\n",0.04*i);
			head_state=true;
			duration = accents[head_count][1]-accents[head_count][0];
			down_up=duration;
			//printf("%d,%d\n",duration,head_count);

		}
		if (head_state)
		{
			if (duration>cvRound(down_up/2))
				head.y=head.y+1;
			else
				head.y=head.y-1;
			duration--;
		}
		if (duration ==0 && head_state)
		{
			head_state=false;
			head.y=200/2;
			head_count++;
		}


		////////////////


		if (hand_count<keyword_count)
		{
			//if (i>keyword_start[hand_count])
			//	hand_count++;

		if (i==keyword_start[hand_count])
		{
			hand_state=true;
			hand_duration = keyword_duration[hand_count];
			//printf("%d,%d\n",hand_duration,hand_count);

		}
		}
		if (hand_state)
		{
			left_hand.x=left_hand_org.x+left_hand_trajectory_x[hand_count][keyword_duration[hand_count]-hand_duration]/2;
			left_hand.y=left_hand_org.y-left_hand_trajectory_y[hand_count][keyword_duration[hand_count]-hand_duration]/2;
			right_hand.x=right_hand_org.x+right_hand_trajectory_x[hand_count][keyword_duration[hand_count]-hand_duration]/2;
			right_hand.y=right_hand_org.y-right_hand_trajectory_y[hand_count][keyword_duration[hand_count]-hand_duration]/2;
			hand_duration--;
		}
		if ((hand_duration == 1 && hand_state) || i== keyword_start[hand_count+1]-1  )
		{
			hand_state=false;
			hand_count++;
			left_hand.x=left_hand_org.x;
			left_hand.y=left_hand_org.y;
			right_hand.x=right_hand_org.x;
			right_hand.y=right_hand_org.y;
		}






		//cvCircle( img, head,20,CV_RGB(0,255,0),-1,8,0);
		
		draw();
		
		//cvShowImage("Test",img);cvWaitKey(40);
		cvWriteFrame( video_out, img );
	}
	cvReleaseVideoWriter( &video_out);
	return 0;



}