
#ifndef _AUDIO_H_
#define _AUDIO_H_

#include <stdio.h>
#include <stdlib.h>
#include "portaudio.h"

/* #define SAMPLE_RATE  (17932) // Test failure to open with this value. */
#define SAMPLE_RATE  (16000)
#define NUM_SECONDS     (5)
#define NUM_CHANNELS    (1)
/* #define DITHER_FLAG     (paDitherOff)  */
#define DITHER_FLAG     (0) /**/
#define FRAMES_PER_BUFFER  (1024)

/* Select sample format. */
#if 0
#define PA_SAMPLE_TYPE  paFloat32
typedef float SAMPLE;
#define SAMPLE_SILENCE  (0.0f)
#elif 1
#define PA_SAMPLE_TYPE  paInt16
typedef short SAMPLE;
#define SAMPLE_SILENCE  (0)
#elif 0
#define PA_SAMPLE_TYPE  paInt8
typedef char SAMPLE;
#define SAMPLE_SILENCE  (0)
#else
#define PA_SAMPLE_TYPE  paUInt8
typedef unsigned char SAMPLE;
#define SAMPLE_SILENCE  (128)

#endif

typedef struct
{
    int          frameIndex;  /* Index into sample array. */
    int          maxFrameIndex;
    SAMPLE      *recordedSamples;
}
paTestData;
/* This routine will be called by the PortAudio engine when audio is needed.
** It may be called at interrupt level on some machines so don't do anything
** that could mess up the system like calling malloc() or free().
*/
static int recordCallback( void *inputBuffer, void *outputBuffer,
                           unsigned long framesPerBuffer,
                           PaTimestamp outTime, void *userData )
{
    paTestData *data = (paTestData*)userData;
    SAMPLE *rptr = (SAMPLE*)inputBuffer;
    SAMPLE *wptr = &data->recordedSamples[data->frameIndex * NUM_CHANNELS];
    long framesToRecord;
    long i;
    int finished;
    unsigned long framesLeft = data->maxFrameIndex - data->frameIndex;
    int samplesToRecord;

    (void) outputBuffer; /* Prevent unused variable warnings. */
    (void) outTime;

    if( framesLeft < framesPerBuffer )
    {
        framesToRecord = framesLeft;
        finished = 1;
    }
    else
    {
        framesToRecord = framesPerBuffer;
        finished = 0;
    }
    
    samplesToRecord = framesToRecord * NUM_CHANNELS;
    
    if( inputBuffer == NULL )
    {
        for( i=0; i<samplesToRecord; i++ )
        {
            *wptr++ = SAMPLE_SILENCE;
        }
    }
    else
    {
        for( i=0; i<samplesToRecord; i++ )
        {
            *wptr++ = *rptr++;
        }
    }
    data->frameIndex += framesToRecord;
    return finished;
}

/* This routine will be called by the PortAudio engine when audio is needed.
** It may be called at interrupt level on some machines so don't do anything
** that could mess up the system like calling malloc() or free().
*/
static int playCallback( void *inputBuffer, void *outputBuffer,
                         unsigned long framesPerBuffer,
                         PaTimestamp outTime, void *userData )
{
    paTestData *data = (paTestData*)userData;
    SAMPLE *rptr = &data->recordedSamples[data->frameIndex * NUM_CHANNELS];
    SAMPLE *wptr = (SAMPLE*)outputBuffer;
    unsigned int i;
    int finished;
    unsigned int framesLeft = data->maxFrameIndex - data->frameIndex;
    unsigned int framesToPlay;
	unsigned int samplesToPlay;
	unsigned int	samplesPerBuffer;

	(void) inputBuffer; /* Prevent unused variable warnings. */
    (void) outTime;
    
    if( framesLeft < framesPerBuffer )
    {
        framesToPlay = framesLeft;
        finished = 1;
    }
    else
    {
        framesToPlay = framesPerBuffer;
        finished = 0;
    }
    
    samplesToPlay = framesToPlay * NUM_CHANNELS;
    samplesPerBuffer = framesPerBuffer * NUM_CHANNELS;

    for( i=0; i<samplesToPlay; i++ )
    {
        *wptr++ = *rptr++;
    }
    for( ; i<framesPerBuffer; i++ )
    {
        *wptr++ = 0;  /* left */
        if( NUM_CHANNELS == 2 ) *wptr++ = 0;  /* right */
    }
    data->frameIndex += framesToPlay;

    return finished;
}

#ifdef EN_BIG_ENDIAN 
 #define EN_SHOULD_SWAP 1 
#endif
#ifdef EN_SHOULD_SWAP
 #define EN_SWAP_2(iii) iii = ((iii & 0x00ff) << 8) | ((iii & 0xff00) >>8)
 #define EN_SWAP_4(iii) iii = ((iii & 0x000000ff) << 24) | ((iii & 0x0000ff00) << 8) | ((iii & 0x00ff0000) >> 8) | ((iii & 0xff000000) >> 24)
#else
 #define EN_SWAP_2(iii)
 #define EN_SWAP_4(iii)
#endif
static int readWAVE(char *file, SAMPLE **data){
  FILE *fid;
  char text[5];
  short snum;
  size_t place;
  int nsamp, num;
  int i;
  text[4]='\0';
  printf("%s\n",file);

  fid = fopen(file,"rb");
  if (fid == NULL)
    {
      printf("Could not read file (%s)\n",file);
      return 0;
    }
  else
    {

	  place = ftell(fid);
  	  printf("At %d\n",place);
      place=fread(text,1,4,fid); // RIFF
	 // 	fseek(fid,4,0);  
	  printf("%d bytes read\n",place);
	
	  place = (int) ftell(fid);
	  printf("At %d\n",place);
	
	  printf("%s\n",text);
      fread(&snum,sizeof(int),1,fid); EN_SWAP_4(snum); // Size
	  printf("%d\n",snum);
      fread(text,sizeof(char),4,fid); // WAVE
	  place = ftell(fid);
  	  printf("At %d\n",place);
	  printf("%s\n",text);
      fread(text,sizeof(char),4,fid); // 'fmt '
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); // chuncksize

	  place = ftell(fid);
  	  printf("At %d\n",place);

      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum); // quantization linePCM
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum); // channels
      fread(&num,sizeof(int),1,fid);  EN_SWAP_4(num); // sample rate
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); //bit rate
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum);// block align
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum);// bits/sample
      printf("bits per sample %d\n",snum);
      place = ftell(fid);
  	  printf("At %d\n",place);
      // Data Subchunck
      fread(text,sizeof(char),4,fid); // data
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); // size
      //printf("%d\n",num/sizeof(SAMPLE));
      if (ferror(fid)){
		printf ("Error occured while reading file (1)");
      }
  	 
      nsamp=(num/NUM_CHANNELS)/sizeof(SAMPLE);
      place = ftell(fid);
  	  printf("At %d\n",place);
      //      printf ("%d\n",nsamp);
      *data = (SAMPLE *) malloc(sizeof(SAMPLE)*nsamp);
      //printf("readed\n");
	  place = ftell(fid);
	  printf("At %d\n",place);
      num=fread(*data,sizeof(SAMPLE),nsamp,fid);
	  if (feof(fid))
		  printf ("File ended\n");
	  else if(ferror(fid))
		  printf("Error found\n");


	  
	  for(i=0; i<nsamp; i++)
	  {
		  EN_SWAP_2((*data)[i]);
	  }
	  
/*       for (i=0; i<num; i++){ */
/* 	printf ("%d\n",(*data)[i]); */
/*       } */

      if (ferror(fid)){
	printf ("Error occured while reading file (2)");
      }

      printf("-->%d -->%d \n",num, nsamp);
      fclose(fid);
      return num;
    }
}

static int writeWAVE(char *file, SAMPLE* data, int nsamp){
  FILE *fid;
  int size= nsamp*sizeof(SAMPLE)*NUM_CHANNELS+4+20+4;
  int chuncksize=16; // for PCM
  short linPCM=1;
  short numCH = NUM_CHANNELS;
  int sr=SAMPLE_RATE;
  int br=SAMPLE_RATE*NUM_CHANNELS*sizeof(SAMPLE); //ByteRate
  short ba=NUM_CHANNELS*sizeof(SAMPLE);
  short bits=sizeof(SAMPLE)*8;
  int numd=nsamp*NUM_CHANNELS*sizeof(SAMPLE);
  

  fid = fopen(file,"wb");
  if( fid == NULL )
    {
      printf("Could not open file (%s)\n",file);
    }
  else
    {
      //Header 
      fprintf(fid,"RIFF");
	  EN_SWAP_4(size); fwrite(&size,sizeof(int), 1, fid);
      fprintf(fid,"WAVE");
      fprintf(fid,"fmt ");

      // FMT subchunck
      // -->Sub chunck size;
      EN_SWAP_4(chuncksize); fwrite(&chuncksize,sizeof(int),1,fid);
      EN_SWAP_2(linPCM); fwrite(&linPCM,sizeof(short),1,fid);
      EN_SWAP_2(numCH); fwrite(&numCH,sizeof(short),1,fid);
      EN_SWAP_4(sr); fwrite(&sr,sizeof(int),1,fid);
      EN_SWAP_4(br); fwrite(&br,sizeof(int),1,fid);
      EN_SWAP_2(ba); fwrite(&ba,sizeof(short),1,fid);
      EN_SWAP_2(bits); fwrite(&bits,sizeof(short),1,fid);


      // Data Subchunck
      fprintf(fid,"data");
      EN_SWAP_4(numd); fwrite(&numd,sizeof(int),1,fid);
	  
	  int i;
	  for(i=0; i<nsamp; i++)
	  {
		  EN_SWAP_2((data)[i]);
	  }
	  
      nsamp=fwrite( data, NUM_CHANNELS * sizeof(SAMPLE), nsamp, fid );
      if (ferror(fid))
	printf("Error occured while writing file");
      fclose( fid );

      // printf("Wrote data to %s %d samples\n",file,nsamp);
    }

  return 0;
}


static int writeRAW(){

  return 0;
}

int readRAW(char *file, SAMPLE **data){
  FILE *fid;
  int numBytes;
  int totalFrames;

  fid = fopen(file,"r");
  if (fid == NULL)
    {	
      printf("Could not read file\n");
      return -1;
    }
  else
    {
      fseek(fid,0,SEEK_END);
      numBytes = ftell(fid);
      totalFrames = numBytes/sizeof(SAMPLE);
      rewind(fid);
      *data =(SAMPLE *)  malloc(numBytes);
      fread (*data, sizeof(SAMPLE), totalFrames ,fid);
      fclose(fid);
      return (totalFrames);
    }  
}



// Gettin the length of a wave file  
static float getWAVETime(char *file, SAMPLE **data){
  FILE *fid;
  char text[5];
  short snum;
  size_t place;
  int nsamp, num;
  text[4]='\0';
  printf("%s\n",file);

  fid = fopen(file,"rb");
  if (fid == NULL)
    {
      printf("Could not read file (%s)\n",file);
      return 0;
    }
  else
    {

	  place = ftell(fid);
  	  printf("At %d\n",place);
      place=fread(text,1,4,fid); // RIFF
	 // 	fseek(fid,4,0);  
	  printf("%d bytes read\n",place);
	
	  place = (int) ftell(fid);
	  printf("At %d\n",place);
	
	  printf("%s\n",text);
      fread(&snum,sizeof(int),1,fid); EN_SWAP_4(snum); // Size
	  printf("%d\n",snum);
      fread(text,sizeof(char),4,fid); // WAVE
	  place = ftell(fid);
  	  printf("At %d\n",place);
	  printf("%s\n",text);
      fread(text,sizeof(char),4,fid); // 'fmt '
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); // chuncksize

	  place = ftell(fid);
  	  printf("At %d\n",place);

      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum); // quantization linePCM
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum); // channels
      fread(&num,sizeof(int),1,fid);  EN_SWAP_4(num); // sample rate
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); //bit rate
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum);// block align
      fread(&snum,sizeof(short),1,fid); EN_SWAP_2(snum);// bits/sample
      printf("bits per sample %d\n",snum);
      place = ftell(fid);
  	  printf("At %d\n",place);
      // Data Subchunck
      fread(text,sizeof(char),4,fid); // data
      fread(&num,sizeof(int),1,fid); EN_SWAP_4(num); // size
      //printf("%d\n",num/sizeof(SAMPLE));
      if (ferror(fid)){
		printf ("Error occured while reading file (1)");
      }
  	 
      nsamp=(num/NUM_CHANNELS)/sizeof(SAMPLE);


// Let's break it here !!!!!

      place = ftell(fid);
  	  printf("At %d\n",place);
      //      printf ("%d\n",nsamp);
      *data = (SAMPLE *) malloc(sizeof(SAMPLE)*nsamp);
      //printf("readed\n");
	  place = ftell(fid);
	  printf("At %d\n",place);
      num=fread(*data,sizeof(SAMPLE),nsamp,fid);
	  if (feof(fid))
		  printf ("File ended\n");
	  else if(ferror(fid))
		  printf("Error found\n");


	  int i;
	  for(i=0; i<nsamp; i++)
	  {
		  EN_SWAP_2((*data)[i]);
	  }
	  
/*       for (i=0; i<num; i++){ */
/* 	printf ("%d\n",(*data)[i]); */
/*       } */

      if (ferror(fid)){
	printf ("Error occured while reading file (2)");
      }

      printf("-->%d -->%d \n",num, nsamp);
      fclose(fid);
      return num;
    }
}

#endif
