#include "audio.h"

/*******************************************************************/
int main(int argc, char *argv[]);
int main(int argc, char *argv[])
{
    PortAudioStream *stream;
    PaError    err;
    paTestData data;
    int        totalFrames;
 
    if (argc < 2)
      exit(-1);
   
    //    totalFrames = readRAW("...",&data.recordedSamples);
    totalFrames = readWAVE(argv[1],&data.recordedSamples);
    data.maxFrameIndex = totalFrames-1; 

    /* Playback recorded data.  -------------------------------------------- */
    data.frameIndex = 0;
    printf("Begin playback.\n"); fflush(stdout);
    err = Pa_OpenStream(
              &stream,
              paNoDevice,
              0,               /* NO input */
              PA_SAMPLE_TYPE,
              NULL,
              Pa_GetDefaultOutputDeviceID(),
              NUM_CHANNELS,
              PA_SAMPLE_TYPE,
              NULL,
              SAMPLE_RATE,
              FRAMES_PER_BUFFER,            /* frames per buffer */
              0,               /* number of buffers, if zero then use default minimum */
              paClipOff,       /* we won't output out of range samples so don't bother clipping them */
              playCallback,
              &data );
    if( err != paNoError ) goto error;

    if( stream )
    {
        err = Pa_StartStream( stream );
        if( err != paNoError ) goto error;
        printf("Waiting for playback to finish.\n"); fflush(stdout);

        while( Pa_StreamActive( stream ) ) Pa_Sleep(100);

        err = Pa_CloseStream( stream );
        if( err != paNoError ) goto error;
        printf("Done.\n"); fflush(stdout);
    }
    free( data.recordedSamples );

    Pa_Terminate();
    return 0;

error:
    Pa_Terminate();
    fprintf( stderr, "An error occured while using the portaudio stream\n" );
    fprintf( stderr, "Error number: %d\n", err );
    fprintf( stderr, "Error message: %s\n", Pa_GetErrorText( err ) );
    return -1;
}

