#include "audio.h"


/*******************************************************************/
int main(int argc, char *argv[]);
int main(int argc, char *argv[])
{
    PortAudioStream *stream;
    PaError    err;
    paTestData data;
    int        i;
    int        totalFrames;
    int        numSamples;
    int        numBytes;
	int k=0;


    if (argc < 2){
      printf("Need to specify a file:\n%s <file.wav>\n\n",argv[0]);
      exit(-1);
    }

    data.maxFrameIndex = totalFrames = NUM_SECONDS * SAMPLE_RATE; /* Record for a few seconds. */
    data.frameIndex = 0;
    numSamples = totalFrames * NUM_CHANNELS;

    numBytes = numSamples * sizeof(SAMPLE);
    data.recordedSamples = (SAMPLE *) malloc( numBytes );
    if( data.recordedSamples == NULL )
    {
        printf("Could not allocate record array.\n");
        exit(1);
    }
    for( i=0; i<numSamples; i++ ) data.recordedSamples[i] = 0;

    err = Pa_Initialize();
    if( err != paNoError ) goto error;

    /* Record some audio. -------------------------------------------- */
    /* 1st - Open Stream
       2on - Start Stream
       3er - if stream is active
       4th - Close Stream */
    err = Pa_OpenStream(
              &stream,
              Pa_GetDefaultInputDeviceID(),
              NUM_CHANNELS,
              PA_SAMPLE_TYPE,
              NULL,
              paNoDevice,
              0,
              PA_SAMPLE_TYPE,
              NULL,
              SAMPLE_RATE,
              FRAMES_PER_BUFFER,            /* frames per buffer */
              0,               /* number of buffers, if zero then use default minimum */
              0, /* paDitherOff, // flags */
              recordCallback,
              &data );
    if( err != paNoError ) goto error;

    err = Pa_StartStream( stream );
    if( err != paNoError ) goto error;


	printf ("Recording ...\n");
    while( Pa_StreamActive( stream ) )
    {
        Pa_Sleep(1000);
		k++;
		printf ("%d seconds\n", k);
	/* Here we could keep doing things while it is recording, here it comes the VAD*/
	//	printf("index = %d\n", data.frameIndex ); fflush(stdout);
    }

    err = Pa_CloseStream( stream );
    if( err != paNoError ) goto error;


    writeWAVE(argv[1], data.recordedSamples, numSamples);

    /* Modify speech, extract anithing it will be usefulll ...... -----------------------
       call de modify speech stuff...*/

    free( data.recordedSamples );

    Pa_Terminate();
    return 0;

error:
    Pa_Terminate();
    fprintf( stderr, "An error occured while using the portaudio stream\n" );
    fprintf( stderr, "Error number: %d\n", err );
    fprintf( stderr, "Error message: %s\n", Pa_GetErrorText( err ) );
    return -1;
}
