#include "audio.h"
#include "timeTransform.h"
#include "tier.h"
#include <math.h>
#include <string>
#include <iostream>
#include <vector>

#define LEADIND_SILENCE_DURATION 0.8F
#define TRAILING_SILENCE_DURATION 0.8F

using namespace std;

int main(int argc, char *argv[])
{
	float time = 10.0f, seg_time = 1.0, offset_time, overlap_time, ori_time;
	char *segment = "";
	char *file = "";
	char *max_filename = ""; FILE *max_file = NULL;
	char *desc_filename = ""; FILE *desc_file = NULL;
	int nsamp, utts, i, j, k;
	SAMPLE *data = NULL;
	SAMPLE *dataout = NULL;
	vector<pair<string, float> > desc_symbols;
	vector<pair<string, float> > max_symbols;
	ENTimeTransform transf;
	bool tr=false;

	int trailingSampleCount, leadingSampleCount, totalSampleCount;
	
	trailingSampleCount = int(TRAILING_SILENCE_DURATION * SAMPLE_RATE);
	leadingSampleCount = int(LEADIND_SILENCE_DURATION * SAMPLE_RATE);

	const int overlap = int(0.010F*SAMPLE_RATE + 0.5);
	float window[overlap];
	
	for (i=0; i<overlap; i++) window[i]=float(i)/(overlap-1);
	
	if (argc < 11){
		cout << "USE: " << argv[0] << 	"-s segment.wav -f out_file.wav -d segment.desc -x ma_times.max -t output_duration -u duration_tier" << endl;
		exit(-1);
	}
	
	for (i=1; i< argc; i++){
		switch (argv[i][1]){
			case 's':
				i++;
				segment=argv[i];
				printf("using segment: %s\n",segment);
				break;
			case 'f':
				i++;
				file=argv[i];
				printf("output file: %s\n", file);
				break;
			case 't':
				i++;
				time=atof(argv[i]);
				printf("output duration: %g\n",time);
				break;
			case 'x':
				i++;
				max_filename=argv[i];
				break;
			case 'd':
				i++;
				desc_filename=argv[i];
				break;
			case 'u':
				i++;
				transf.initFromDurationTier(string(argv[i]));
				tr=true;
				break;
			default:
				cout << "Unknown command option " << *argv[i] << endl;
				exit(-1);
		}
	}		
	
	// next open wav description
	printf("Reading description\n");
	desc_file = fopen(desc_filename, "r");
	if(desc_file)
	{
		char symbol[16];
		float time = 0.0f;
		
		while(fscanf(desc_file, "%s %f\n", symbol, &time) == 2) 
		{
			desc_symbols.push_back(pair<string,float>(string(symbol),time));
		}
		fclose(desc_file);
	}
	
	// first generate output wav
	printf("Generating output wav\n");
	nsamp = readWAVE(segment,&data);
	seg_time = float(nsamp)/SAMPLE_RATE;
	offset_time = float(nsamp-overlap)/SAMPLE_RATE;
	overlap_time = float(overlap)/SAMPLE_RATE;
	
	utts = (int) ((time-overlap_time)/(seg_time+overlap_time)+0.5);
	cout << "---->>" << utts << " " << seg_time << " " << time << " " << time/seg_time << endl;
	
	totalSampleCount = leadingSampleCount + trailingSampleCount + utts*nsamp;
	
	dataout = (SAMPLE*)malloc(totalSampleCount*sizeof(SAMPLE));
	memset(dataout, 0, totalSampleCount*sizeof(SAMPLE));
	
	// Prepare segment (windowing)
	for (i=0; i<overlap; i++)
	{
		data[i] = short(window[i]*data[i]);
		data[nsamp-1-i] = short(window[i]*data[nsamp-1-i]);
	}
	// skip leading silence samples
	k=leadingSampleCount;
	cout << "Leading sample count " << leadingSampleCount << endl;
	for (i=0; i<utts; i++){
		for(j=0; j<nsamp; j++){
			dataout[k]+=data[j];
			k++;
		}
		k-=overlap;
	}
	free(data);
	
	writeWAVE(file,dataout,totalSampleCount);
	
	free(dataout);
	
	// Writing MAX file
	printf("Writing MAX file\n");
	max_file = fopen(max_filename, "w");
	
	float global_offset = 0.0f;
	if(max_file)
	{
		fprintf(max_file, "%d\n", 2+utts*desc_symbols.size());
		if (tr)
			fprintf(max_file, "%s %g\n", "X", transf.transformTime(LEADIND_SILENCE_DURATION));
		else
			fprintf(max_file, "%s %g\n", "X", LEADIND_SILENCE_DURATION);

		global_offset += LEADIND_SILENCE_DURATION;
		for(i=0; i<utts; i++)
		{
			for(j=0; j<int(desc_symbols.size()); j++)
			{
				ori_time = desc_symbols[j].second + global_offset;
				if (tr)
					fprintf(max_file, "%s %g\n", desc_symbols[j].first.c_str(), transf.transformTime(ori_time));
				else
					fprintf(max_file, "%s %g\n", desc_symbols[j].first.c_str(), ori_time);
			}
			
			global_offset += offset_time;
		}
		ori_time = global_offset + TRAILING_SILENCE_DURATION;
		if (tr)
			fprintf(max_file, "%s %g\n", "X", transf.transformTime(ori_time));
		else
			fprintf(max_file, "%s %g\n", "X", ori_time);
		
		fclose(max_file);
	}
	
	return 0;
}
