#include <math.h>
#include <iostream>
#include <vector>
#include <fstream>
#include <string>

#include "stats.h"
#include "tier.h"

#define MAXLINE 200
#define THRESTIME 0.030F
#define STEP 0.75F
#define STD_REF 2

class ModifyD{

private:
	float step; 

public:
 
	Tier speechrate; 
	Tier durations; //Duration Tier.

	ModifyD(){speechrate.empty(); durations.empty(); step=STEP;}
	ModifyD(float s){ModifyD(); step=s;}


	inline int sigmoide(Tier &sr, Tier &dur, float factor){
		Tier::iterator it_dur;	
		float std=getTierStd(sr);
		float mean=getMean(sr);
		factor = factor*STD_REF/std;

		dur=Tier(sr);

		for(it_dur=dur.begin(); it_dur!=dur.end(); it_dur++)
			it_dur->second = 2/(1+exp(factor*(it_dur->second - mean)));

		return 0;
	}

	int sr2durScale(Tier &sr, Tier &dur, float factor) {

		cout << "Speech rate factor: " << factor << endl;
		
		float mean;
		Tier::iterator it_dur;	
		factor = factor*STD_REF/getTierStd(sr);
		cout << getTierStd(sr) << endl;
		dur=Tier(sr);

		mean= removeMean(dur);
		//max = getMaxAbs(dur);
		cout << "SR mean " << mean << endl;
		for(it_dur=dur.begin(); it_dur!=dur.end(); it_dur++){
			cout << it_dur->second << " " << it_dur->second + mean << endl;
			it_dur->second += 1-factor*it_dur->second;
		}
	//	addMean(dur,factor*mean-1);
		invert(dur);
		return 0;
	}

	inline int plusone(Tier &sr){
		Tier::iterator it;
		for (it=sr.begin(); it!=sr.end(); it++)
			it->second += 1;
		return 0;
	}	

	inline int invert(Tier &sr){
		Tier::iterator it;
		for (it=sr.begin(); it!=sr.end(); it++)
			it->second = 1/it->second;
		return 0;
	}

	int modify(float factor){
//		plusone(speechrate,durations);
//		invert(speechrate,durations);
//		sr2durScale(speechrate,durations,factor);
		sigmoide(speechrate,durations,factor);

		return 0;
	}

	int EnergyPeakstoSpeechRate(PointProcess &en, Tier &data){
		PointProcess::iterator it_en;
		Tier::iterator  it_int;
		Tier integral;
		pair <float, float> p;
		float time=0;	
		int cum=-1;

		// Integrate
		for (it_en=en.begin(); it_en != en.end(); it_en++){
			p.first = *it_en;
			p.second = ++cum;
			integral.push_back(p);
		}
		integral.back().second --;

		writeTier("prova_int.DurationTier",integral,"Duration");

		// To Speech Rate
		cum=0;
		it_int = integral.begin();
		for (time=0; time<integral.back().first-step; time += step/2){
			for (; it_int != integral.end(); it_int ++){
				if (it_int->first > time){
					cum = -it_int->second;
					for (; it_int != integral.end(); it_int ++){
						if (it_int->first > time+step){
							p.first = time+step/2;
							p.second = (cum + it_int->second)/step;
							data.push_back(p);	
							break;
						}
					}
					break;
				}
			}
		}
		for (; it_int != integral.end(); it_int ++)
			if (it_int->first > time)
				cum = -it_int->second;
			cout << cum << endl;
		p.first = time+step/2;
		p.second = cum + integral.back().second;
		cout << p.first << " " << cum << " " << it_int-> second << " " << p.second << endl;
		data.push_back(p);	

		p.first = integral.back().first;
		p.second = 0;
		data.push_back(p);

		return 0;
	}
};

int main (int argc, char *argv[]){

	ModifyD d;
	string sfile, ofile;
	Stats sts;
	PointProcess en;
	PointProcess::iterator it;
	float aFactor=1.0F;

	if (argc < 7){
		cout << "USE: " << argv[0] << " -s statsname -o OutputTier -a amplifFactor" << endl;
		exit (-1);
	}

	for (int i=1; i<argc ; i++){
		switch (argv[i][1]){
		case 's':
			sfile = string(argv[++i]);
			break;
		case 'o':
			ofile = string(argv[++i]);
			break;
		case 'a':
			aFactor = atof(argv[++i]);
			break;

		default:
			break;
		}
	}

	cout <<  "Reading stats " << endl;
	sts.readStats(sfile);
	cout << "getting energy " << endl;
	en = sts.getEnergyPeaks();

	if (!en.empty())
		for (it=en.begin()+1; it!=en.end(); it ++)
			if ((*it - *(it-1)) < THRESTIME){
				it=en.erase(it-1);
			}

	writePointProcess("newpeaks.PointProcess",en);
	cout << "Calculatin speech rate" << endl;
	d.EnergyPeakstoSpeechRate(en, d.speechrate);
	cout << "writing dur tier" << endl;
	writeTier("sr.DurationTier",d.speechrate,"Duration");

	cout << "modifying " << endl;
	d.modify(aFactor);
	writeTier(ofile,d.durations,"Duration");
	return 0;
}