#include <iostream>
#include <vector>
#include <fstream>
#include <string>
#include <math.h>

#include "tier.h"


#define INFPITCH 1000
#define REFERENCE_STD 25
#ifndef PI
#define PI 3.1415
#endif

using namespace std;

class ModifyF0{

private:
 
  float drift_a;
  float drift_b;

public:
  vector<pair<float, float> > data;	
  enum {SAD,SURPRISED,ANGRY,DISGUSTED,HAPPY,FEARFULL};
	
  ModifyF0(){
    data.empty();
  }

  // Pitch Modification funtions -----------------------
  int modify(float a, float o,string file=""){
	  if (file.empty())
		removeDriftAmplifAddDrift(a);
	  else	
		removeLineAmplAddLine(file,a);

    addOffset(o);
	//modulatef0(50,50);

    return 0;
  }

  inline int removeDrift(){
	  Tier::iterator it;
	for (it=data.begin(); it != data.end(); it++){
      it->second -= it->first*drift_a + drift_b;
    }
    return 0;
  }

  inline int addDrift(){
	vector<pair<float, float> >::iterator it;
	for (it=data.begin(); it != data.end(); it++){
		it->second +=  it->first*drift_a + drift_b;
    }
  }

  inline float removeDrift(Tier::iterator it){
      return (it->second - it->first*drift_a - drift_b);
  }
  inline float addDrift(Tier::iterator it){
      return (it->second + it->first*drift_a + drift_b);
  }

  int calculateDrift(){
	vector<pair< float, float> >::iterator it;
    vector<float> x;

    float cumt=0, cumf=0, cumft=0, cumtt=0;
    for (it=data.begin(); it != data.end(); it++){
      cumf += it->second;
      cumt += it->first;
      cumft += it->second*it->first;
      cumtt += it->first*it->first;
    }

    drift_a=(cumft - cumf*cumt/data.size()) / (cumtt-cumt*cumt/data.size());
    drift_b=cumf/data.size()-drift_a*cumt/data.size();
	return 0;
  }

  inline int addOffset(float f0offset){
    vector<pair<float,float> >::iterator it;
    for (it=data.begin(); it != data.end(); it++){
      it->second += f0offset;
    }
	return 0;
  }

  inline int modulatef0(int freq,int ampl){
    vector<pair< float, float> >::iterator it;	
	for (it=data.begin(); it != data.end(); it++){
		it->second += 5*sin(it->first*PI);
    }
	return 0;
  }

  inline int removeDriftAmplifAddDrift(float factor){
	cout << "  **Drift Processing** " << endl;
    vector<pair< float, float> >::iterator it;
	float tmp;
	int s;

	calculateDrift();

    for (it=data.begin(); it != data.end(); it++){
		tmp=removeDrift(it);
		s = tmp>0?1:-1;
		tmp = fabs(tmp);
		it->second = pow(tmp,factor)*s;
		it->second = addDrift(it);	
    }
    return 0;
  }

  inline int removeLineAmplAddLine(string file, float factor){
	cout << "  **Line Processing** " << endl;
	Tier line, substract;
	Tier::iterator it_data;
	Tier::iterator it_line;
	float std,tmp;
	
	readTier(file,line);
	std=getPitchStd(line);

	cout << "STD " << std << endl;


	factor = (REFERENCE_STD/std)*factor;
	cout << "Real Factor " << factor << endl;

	it_line = line.begin();
    for (it_data=data.begin(); it_data != data.end(); it_data++, it_line++){
		tmp=it_data->second - it_line->second;
	//	substract.push_back(pair<float,float>(it_data->first,tmp));
	//	it_data->second = tmp*(2/(1+exp(-factor*tmp))) + it_line->second;	
		it_data->second = tmp*factor + it_line->second;	
    }
//	writeTier(string("recorded_subs.PitchTier"),substract,"Pitch");
    return 0;
  }

  inline float getPitchStd(Tier &line){
	vector<pair<float,float> >::iterator it_data,it_line;

	float cum=0;
	float cum2=0;
	float diff;

	it_line = line.begin();
	for (it_data=data.begin(); it_data != data.end(); it_data++,it_line++){
		diff = it_data->second - it_line->second;
		cum += diff;
		cum2 += diff*diff;
	}
	cum=cum/data.size();
	cum2 = cum2/(data.size()-1);
	
	return sqrt(cum2-cum*cum);
  }

  inline float getMAX(){
	vector<pair<float,float> >::iterator it;
	float max=INFPITCH;
	for (it=data.begin(); it != data.end(); it++){
		if (it->second > max)
			max=it->second;
	}
	return fabs(max);
  }
  
	// Emotion stuff -------------------------
  int getEMO (){
	
  }


};


int  main (int argc, char *argv[]){
  if (argc < 7){
    cerr << "USE: " << argv[0] << "-i ori_file " << "-d dest_file " << "-a PitchAmplitudeStretch " << "-o PitchOffset" << endl;
    return -1;
  }
  

  string linefile;
  string ifile, ofile;
  float amplitud=1.0F, offset=0.0F;
  int i;
 
  for (i=1; i<argc; i++){
 
    switch (argv[i][1]){
    case 'i':
	  i++;
      ifile=string(argv[i]);
	  cout << "Reading file " << ifile << endl;
      break;
    case 'd':
	  i++;
      ofile=string(argv[i]);
	  cout << "Outout file " << ofile << endl;
      break;
    case 'a':
	  i++;
      amplitud=atof(argv[i]);
	  cout << "Power factor " << amplitud <<  endl;
      break;
    case 'o':
		i++;
      offset =atof(argv[i]);
	  cout << "Offset " << offset << endl;
      break;
    case 'l':
		i++;
		linefile=string(argv[i]);
		cout << "Line subs " << linefile << endl;
		break;

    default:
      printf ("Unknown command option %c with argument %s\n",*argv[i], argv[i+1]);
      exit(-1);
    }

  }

  ModifyF0 m;
  cout << "Reading file " << endl;
  readTier(ifile,m.data);
  cout << "Modifying " << endl;
  m.modify(amplitud, offset,linefile);
  cout << "Writting " << endl;
  writeTier(ofile,m.data,"Pitch");
  return 0;
}


