#include "tier.h"
#include <string>
#include <iostream>
#include <fstream>
#include <math.h>



int readTier (string file, Tier &data){
	
    pair<float, float> p;
    string text;
    ifstream f_in(file.c_str());
    char c[MAXLINE];
	float length;

	if (f_in.eof() || f_in.fail()){
		cout << "Error reading file "<< file << endl;
		exit(-1);
	}

    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE);
    f_in.getline(c,MAXLINE); 
	length = atof(c);
    f_in.getline(c,MAXLINE); 

	cout << "--> " << length << endl;
	
    while (!f_in.eof()){
      f_in >> text;

	  if (text == "") continue;

      p.first = atof(text.c_str());
      text=string();
      if (f_in.eof()){
		cout << "Error reading Tier File (wrong format)" << p.first << endl;
		return -1;
	  }
      f_in >> text;
	  while (text == "" && !f_in.eof()) f_in >> text;

      p.second = atof(text.c_str());

      text=string();
      data.push_back(p);
    }
	cout << "Tier Readed " << endl;
	if (data.back().first < length+data.front().first){
		p.first = length + data.front().first;
		p.second = data.back().second;
	}
	if (data.front().first > 0){
		p.first = 0;
		p.second = data.front().second;
		data.insert(data.begin(),p);
	}
	

/*	for (int i=0; i<data.size(); i++){
		cerr << "--" << data[i].first << " " << data[i].second << endl;
	}*/

    return 0;
  }

int writeTier(string file, Tier &data, string type){
	cout << "Writting on " << file << endl;
	Tier::iterator it;
    
	if (!data.empty()){
		ofstream f_out(file.c_str());
		f_out << "File type = \"ooTextFile short\"" << endl;
		f_out << "\"" << type << "Tier\""<< endl << endl;
		f_out << '0' << endl;
		f_out << data.back().first << endl;
		f_out << data.size() << endl;

		for (it=data.begin(); it!=data.end(); it++){
		f_out << it->first << endl;
		f_out << it->second << endl;
		}

		f_out.close();
	}else
		cerr << "Empty Tier, nothing writen" << endl;
			
    return 0;
  }

int readPointProcess(string file, PointProcess &data){

	string text;	
    ifstream f_in(file.c_str());
    char c[MAXLINE];

	if (f_in.eof() || f_in.fail()){
		cout << "Error reading Point Process file "<< file << endl;
		exit(-1);
	}

    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE);
    f_in.getline(c,MAXLINE); 
    f_in.getline(c,MAXLINE); 

    while (!f_in.eof() && !f_in.bad()){
      f_in >> text;
	  if (text == "") continue;
      data.push_back(atof(text.c_str()));
    }

    return 0;
  }



int writePointProcess(string file, PointProcess &data){
	cout << "Writting on " << file << endl;
	PointProcess::iterator it;


	if(!data.empty()){
	    ofstream f_out(file.c_str());
		f_out << "File type = \"ooTextFile short\"" << endl;
		f_out << "\"PointProcess\""<< endl << endl;
		f_out << '0' << endl;
		f_out << data.back() << endl;
		f_out << data.size() << endl;

	    for (it=data.begin(); it!=data.end(); it++){
		  f_out << *it << endl;
		}
		f_out.close();
	}
    return 0;
  }


float getTierStd(Tier &d){
	Tier::iterator it_d;

	float cum=0,cum2=0;

	for (it_d=d.begin(); it_d != d.end(); it_d++){
		cum += it_d->second;
		cum2 += it_d->second * it_d->second;
	}
	cum=cum/d.size();
	cum2 = cum2/(d.size()-1);
	
	return sqrt(cum2-cum*cum);
 }


float removeMean(Tier &d){
	Tier::iterator it_d;
	float mean=0;

	for (it_d=d.begin(); it_d != d.end(); it_d++)
		mean += it_d->second;
	mean /= d.size();
	for (it_d=d.begin(); it_d != d.end(); it_d++)
		it_d->second -= mean;
	return mean;
}


int addMean(Tier &d, float mean){
	Tier::iterator it_d;
	for (it_d=d.begin(); it_d != d.end(); it_d++)
		it_d->second += mean;
	return 0;
}

float getMaxAbs(Tier &d){
	Tier::iterator it_d;
	float max=abs(d.begin()->second);
	for (it_d=d.begin(); it_d != d.end(); it_d++)
		if (it_d->second > max)
			max = abs(it_d->second);
	return 0;
}
 

float getMean(Tier &d){
	Tier::iterator it_d;
	float mean=0, zero=0;

	for (it_d=d.begin(); it_d != d.end(); it_d++)
		if (it_d->second != 0)
			mean += it_d->second;
		else
			zero++;
	
	return mean/(d.size()-zero);
}