#include <iostream>
#include "timeTransform.h"

void ENTimeTransform::initFromDurationTier(const string filename)
{
	unsigned int i = 0;
	float lastTime = 0.0, lastValue = 1.0, lastPValue = 0.0f, currentTime, currentValue, a, b, c;
	readTier(filename,_durationTier);
	
	_parabolas.clear();
	
	// skipping negative times in duration tier
	/*i=1;
	if(_durationTier.size() > 0)
	{
		lastTime = _durationTier[0].first;
		lastValue = _durationTier[0].second; 
	}*/
	while(i < _durationTier.size() && _durationTier[i].first < 0.0f) i++;
	
	// start with parabolas evaluation

	

	while(i < _durationTier.size())
	{
		currentTime = _durationTier[i].first;
		currentValue = _durationTier[i].second;
		
		if(currentTime > lastTime)
		{
			a = (currentValue - lastValue) / (currentTime - lastTime);
			b = lastValue - a*lastTime;
			c = lastPValue - (0.5*a*lastTime + b)*lastTime;
			
			cout << "parab  " << a << " " << b << " " << c << endl;

			ENParabola parabola;
			
			parabola.endTime = currentTime;
			parabola.a = a;
			parabola.b = b;
			parabola.c = c;
			
			_parabolas.push_back(parabola);
			
			lastPValue = (0.5*a*currentTime + b)*currentTime + c;
			lastTime = currentTime;
			
		}
		lastValue = currentValue;
		i++;
	}
}

float ENTimeTransform::transformTime(float time)
{
	unsigned int i = 0;
	
	while(i<_parabolas.size())
	{
		if(time < _parabolas[i].endTime)
		{
			break;
		}
		i++;
	}
	
	// Found one
	if(i==_parabolas.size() && i>0) i--;
	if(i<_parabolas.size())
	{
		return (0.5*_parabolas[i].a*time + _parabolas[i].b)*time + _parabolas[i].c;
	}
	else
	{
		return time;
	}
}
