//Arman Savran, 2005
//eNTERFACE'05

#include "FaceModel.h"
#include "buffer.h"
#include <fstream>
#include <string>
#include "SDL_opengl.h"
#include <math.h>
#include "timeTransform.h"

#include <iostream>


#define TMPSIZE 100


using namespace std;


//Render modes
void RenderPoints()
{
	glShadeModel(GL_FLAT);	
	glPolygonMode(GL_FRONT, GL_POINT);
    glPolygonMode(GL_BACK, GL_POINT); 
}

void RenderWireframe()
{
	glShadeModel(GL_FLAT);	
    glPolygonMode(GL_FRONT, GL_LINE);
    glPolygonMode(GL_BACK, GL_LINE);
}

void RenderFlatShaded()
{
	glShadeModel(GL_FLAT);	
    glPolygonMode(GL_FRONT, GL_FILL);
    glPolygonMode(GL_BACK, GL_FILL);
}

void RenderSmoothShaded()
{
	glShadeModel(GL_SMOOTH);	
	glPolygonMode(GL_FRONT, GL_FILL);
    glPolygonMode(GL_BACK, GL_FILL);
}




FaceModel::FaceModel(void)
	: state(0)
	, numVertices(0), numTriangles(0), numAnimUnits(0), numShapeUnits(0)
	, pVertices(0), pOrgVertices(0), pIndices(0), pAnimUnits(0), pShapeUnits(0)
	, pVerNormals(0), pTriNormals(0)
	, fps(0), numFrames(0), pVertSeq(0), pFrameTimes(0)
{
	SetRenderMode(SMOOTHSHADED);
}

FaceModel::~FaceModel(void)
{
	Clear();
}

void FaceModel::Clear()
{
	state = 0;
	DEL_DYNARRAY(pVertices);
	DEL_DYNARRAY(pIndices);
	DEL_DYNARRAY(pOrgVertices);
	DEL_DYNARRAY(pVerNormals);
	DEL_DYNARRAY(pTriNormals);
	DEL_DYNARRAY(pAnimUnits);
	DEL_DYNARRAY(pShapeUnits);
	fps = 0;
	numFrames = 0;
	DEL_DYNARRAY(pVertSeq);
	DEL_DYNARRAY(pFrameTimes);	
}

short FaceModel::ReadModel(const char *filepath)
{
	Clear();

	ifstream ifs(filepath, ios::in);
	if (!ifs)
		return 2;

	try {
		string label;
		char temp[TMPSIZE];
		while (ifs.good()) {
			ifs.getline(temp, TMPSIZE);
			if (temp[0] == '#') {
								
				label = &temp[2];

				int num;
				if (strcmp(label.c_str(), "VERTEX LIST:") == 0) {
					//cout << temp << endl;
					ifs >> num;
					if (num < 0)
						throw (short) 4;
					else {
						numVertices = (unsigned long) num;
						InitBuffer((void *&) pVertices, numVertices*3*sizeof(*pVertices));						
						InitBuffer((void *&) pVerNormals, numVertices*3*sizeof(*pVerNormals));
						num *= 3;
						float *fptr = pVertices;
						for (int i=0; i<num; i++)
							ifs >> *(fptr++);
						//for (int i=0; i<num; i++) {
						//	cout << pVertices[i];
						//	if (i % 3 == 2)
						//		cout << endl;
						//}
					}
				}
				else if (strcmp(label.c_str(), "FACE LIST:") == 0) {
					//cout << temp << endl;
					ifs >> num;
					if (num < 0)
						throw (short) 4;
					else {						
						numTriangles = (FaceIndex) num;
						InitBuffer((void *&) pIndices, numTriangles*3*sizeof(*pIndices));
						InitBuffer((void *&) pTriNormals, numTriangles*3*sizeof(*pTriNormals));
						num *= 3;
						FaceIndex *fptr = pIndices;
						for (int i=0; i<num; i++)
							ifs >> *(fptr++);
						//for (int i=0; i<num; i++) {
						//	cout << pIndices[i];
						//	if (i % 3 == 2)
						//		cout << endl;
						//}
					}
				}
				else if (strcmp(label.c_str(), "ANIMATION UNITS LIST:") == 0) {
					//cout << temp << endl;
					ifs >> num;
					if (num < 0)
						throw (short) 4;
					else {						
						numAnimUnits = (unsigned short) num;
						pAnimUnits = new AnimUnit[num];
						
						AnimUnit *pA = pAnimUnits;
						for (int i=0; i< (int)numAnimUnits; i++, pA++) {
							ifs.getline(temp, TMPSIZE);
							ifs.getline(temp, TMPSIZE);
							ifs.getline(temp, TMPSIZE);
							//cout << temp << endl;
							label = &temp[2];
							pA->SetName(label.c_str(), label.length());
							streampos pos = ifs.tellg();
							ifs.getline(temp, TMPSIZE);
							if (temp[0] != '#')
								ifs.seekg(pos);
							ifs >> num;							
							pA->AllocVerttrans(num);

							float *fptr = pA->pWeights;
							for (int j=0; j<num; j++) {
								ifs >> pA->pIndices[j];
								for (int k=0; k<3; k++)
									ifs >> *fptr++;
							}

							//cout << pA->unit_name << "\n" << num << endl;
							//for (int j=0; j<num; j++) {
							//	cout << pA->pIndices[j] << " ";
							//	for (int k=0; k<3; k++)
							//		cout << " " << pA->pWeights[3*j+k];
							//	cout << endl;
							//}
						
						}


							

						//if(InitBuffer((void *&) pIndices, numTriangles*3*sizeof(*pIndices)))
						//	throw (short) 1;							
						//num *= 3;
						//FaceIndex *fptr = pIndices;
						//for (int i=0; i<num; i++)
						//	ifs >> *(fptr++);
						//for (int i=0; i<num; i++) {
						//	cout << pIndices[i];
						//	if (i % 3 == 2)
						//		cout << endl;
						//}
					}
				}
				else if (strcmp(label.c_str(), "SHAPE UNITS LIST:") == 0) {
					//cout << temp << endl;
				//	ifs >> num;
				//	if (num < 0)
				//		throw (short) 3;
				//	else {
				//		DEL_DYNARRAY(pAnimUnits);
				//		numTriangles = (unsigned long) num;
				//		if(InitBuffer((void *&) pIndices, numTriangles*3*sizeof(*pIndices)))
				//			throw (short) 1;							
				//		num *= 3;
				}
			}
		}

		InitBufferCopy((void *&)pOrgVertices, pVertices, numVertices*3*sizeof(*pOrgVertices));


		ifs.close();
	}
	catch(bad_alloc x) { //memory allocation error		
		ifs.close();		
		return 1;
	}
	catch(short tval) {		
		ifs.close();
        return tval;
	}
	catch(...)	{		
		ifs.close();		
		return -1;        
	}

	state = 1;


	return 0;
}

short FaceModel::ReadVRMLAnim(const char *filepath)
{
	Clear();

	ifstream ifs(filepath, ios::in);
	if (!ifs)
		return 2;

	{ //Check the VRML file
		string str;
		ifs >> str;
		if (str != "#VRML") { //wrong VRML file			
			ifs.close();
			return 4;
		}
	}


	try {		
		char temp[TMPSIZE];
		string str;
		while (ifs.good()) {
			ifs.getline(temp, TMPSIZE);

			if (strcmp(temp, "    coord DEF faceInit Coordinate{") == 0) {

				//Read vertices
				ifs.getline(temp, TMPSIZE);
				
				streampos pos = ifs.tellg();
				//count vertices
				int count = 0;				
				do {
					ifs.getline(temp, TMPSIZE);
					str = temp;
					count++;
				} while (str.find(']', 0) == string::npos);
				count--;

				ifs.seekg(pos);

				//now get the vertices
				numVertices = count;
				InitBuffer((void *&) pVertices, numVertices*3*sizeof(*pVertices));
				InitBuffer((void *&) pVerNormals, numVertices*3*sizeof(*pVerNormals));

				float *fptr = pVertices;
				for (int i=0; i<count; i++, fptr+=3) {				
					ifs >> fptr[0] >> fptr[1] >> fptr[2];		
					ifs >> str;
				}


				//Read Triangles
				ifs.getline(temp, TMPSIZE);
				ifs.getline(temp, TMPSIZE);
				ifs.getline(temp, TMPSIZE);
				ifs.getline(temp, TMPSIZE);

				pos = ifs.tellg();
				//count triangles
				count = 0;				
				do {
					ifs.getline(temp, TMPSIZE);
					str = temp;
					count++;
				} while (str.find(']', 0) == string::npos);
				count--;

				ifs.seekg(pos);

				//now get the triangles
				numTriangles = (FaceIndex) count;
				InitBuffer((void *&) pIndices, numTriangles*3*sizeof(*pIndices));
				InitBuffer((void *&) pTriNormals, numTriangles*3*sizeof(*pTriNormals));

				FaceIndex *fiptr = pIndices;
				for (i=0; i<count; i++) {					
					ifs >> str;
					*fiptr++ = (FaceIndex) atoi(str.c_str());
					ifs >> str;
					*fiptr++ = (FaceIndex) atoi(str.c_str());
					ifs >> str;
					*fiptr++ = (FaceIndex) atoi(str.c_str());

					ifs.getline(temp, TMPSIZE);
				}
			}
			else if (strcmp(temp, "  DEF faceMorph CoordinateInterpolator{") == 0) {

				ifs >> str;
				streampos pos = ifs.tellg();
				//count the # of frames
				int count = 0;
				do {
					ifs >> str;					
					count++;
				} while (str.find(']', 0) == string::npos);
				count--;

				if (count > 0) {
					ifs.seekg(pos);
					numFrames = count;
					InitBuffer((void *&) pFrameTimes, numFrames*sizeof(*pFrameTimes));
					InitBuffer((void *&) pVertSeq, numFrames*numVertices*3*sizeof(pVertSeq));
					//get the frame times
					for (unsigned long i=0; i<numFrames; i++)
						ifs >> pFrameTimes[i];
					ifs.getline(temp, TMPSIZE);

					//get the frames
					ifs.getline(temp, TMPSIZE);
					float *fptr = pVertSeq;
					for (i=0; i<numFrames; i++) {
						ifs.getline(temp, TMPSIZE);
						for (unsigned long j=0; j<numVertices; j++, fptr+=3) {
							ifs >> fptr[0] >> fptr[1] >> fptr[2];
							ifs >> str;
						}
						ifs.getline(temp, TMPSIZE);
					}
				}
			}		
		}

		InitBufferCopy((void *&)pOrgVertices, pVertices, numVertices*3*sizeof(*pOrgVertices));


		ifs.close();
	}
	catch(bad_alloc x) { //memory allocation error		
		ifs.close();		
		return 1;
	}
	catch(short tval) {		
		ifs.close();
        return tval;
	}
	catch(...)	{		
		ifs.close();		
		return -1;        
	}

	state = -1;


	return 0;
}

void FaceModel::MakeOriginal()
{
	if (state)
		memcpy(pVertices, pOrgVertices, numTriangles*3*sizeof(*pIndices));
}

void FaceModel::SetRenderMode(RENDERMODE mode)
{
	rendermode = mode;
	if (mode == POINTS)
		pApplyRenderMode = &RenderPoints;
	else if (mode == WIREFRAME)
		pApplyRenderMode = &RenderWireframe;
	else if (mode == FLATSHADED)
		pApplyRenderMode = &RenderFlatShaded;
	else if (mode == SMOOTHSHADED)
		pApplyRenderMode = &RenderSmoothShaded;
	else {
		rendermode = SMOOTHSHADED;
		pApplyRenderMode = &RenderSmoothShaded;
	}
}

void add3v(float *dst, const float *src) //dst = dst + src (3 vector)
{
	*dst++ += *src++;
	*dst++ += *src++;
	*dst += *src;
}

void normalize(float *v3)
{
	float mag = sqrt(v3[0]*v3[0] + v3[1]*v3[1] + v3[2]*v3[2]);
	if (mag > 1e-06) {
		mag = 1.0f/mag;
		*v3++ *= mag;
		*v3++ *= mag;
		*v3 *= mag;
	}	
}

void FaceModel::ComputeNormals()
{
	if (pVerNormals) {
		memset(pVerNormals, 0, 3*numVertices*sizeof(*pVerNormals));
		float *pN = pTriNormals;
		FaceIndex *pind = pIndices;
		for (FaceIndex i=0; i<numTriangles; i++, pN+=3) {
			//Compute triangle normal
			unsigned long i0,i1,i2;
			i0 = 3 * *(pind++);
			i1 = 3 * *(pind++);
			i2 = 3 * *(pind++);

			float *p1=pVertices+i0;
			float *p2=pVertices+i1;
			float *p3=pVertices+i2;
			float u[3] = {p2[0]-p1[0], p2[1]-p1[1], p2[2]-p1[2]};
			float v[3] = {p3[0]-p1[0], p3[1]-p1[1], p3[2]-p1[2]};

			pN[0] = u[1]*v[2] - u[2]*v[1];
			pN[1] = u[2]*v[0] - u[0]*v[2];
			pN[2] = u[0]*v[1] - u[1]*v[0];


			////accumulate polygon normals for each vertex
			add3v(pVerNormals + i0, pN);
			add3v(pVerNormals + i1, pN);
			add3v(pVerNormals + i2, pN);			
		}

		//normalize the vertex normals
		pN = pVerNormals;
		for (i=0; i<numVertices; i++, pN+=3)
			normalize(pN);		
	}
}


void FaceModel::RenderGL()
{
	//Compute normals
	ComputeNormals();

	//Set material properties
	static float diffuse[3] = {0.91764712f, 0.82352948f, 0.61960787f};
	//static float specular[3] = {0.98039222, 0.97647065, 0.93725497};
	glMaterialf(GL_FRONT_AND_BACK, GL_AMBIENT, 0.0);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diffuse);
	//glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular);
	//glMaterialf(GL_FRONT, GL_SHININESS, 0.25);


	pApplyRenderMode();

	glVertexPointer(3, GL_FLOAT, 0, pVertices);
	glNormalPointer(GL_FLOAT, 0, pVerNormals);
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_NORMAL_ARRAY);
	
	glDrawElements(GL_TRIANGLES, 3*numTriangles, GL_UNSIGNED_SHORT, pIndices);

	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_NORMAL_ARRAY);
}


void FaceModel::Deform(unsigned long frame_no)
{
	if (state && frame_no >= 0 && frame_no < numFrames)
		memcpy(pVertices, pVertSeq+frame_no*numVertices*3, numVertices*3*sizeof(float));	
}

int FaceModel::GetAnimUnitIndex(const char *name) const
{
	for (int i=0; i<numAnimUnits; i++) {
		if (strcmp(name, pAnimUnits[i].unit_name) == 0)
			return i;
	}
	return -1;
}

void FaceModel::SetFPS(float val)
{
	if (val <= 0)
		fps = 0;
	else if (val > 120)
		fps = 120;
	else
		fps = val;
}

bool FaceModel::AllocFrames(unsigned long num_frames)
{
	numFrames = num_frames;
	return InitBuffer((void*&) pVertSeq, numFrames*numVertices*3*sizeof(*pVertSeq));
}

void FaceModel::CalcFrameCoords(unsigned long frameno, const float *params)
{
	if (frameno < numFrames) {
		float *pframevert = pVertSeq + frameno*numVertices*3;		
		memcpy(pframevert, pOrgVertices, numVertices*3*sizeof(*pframevert));
		for (unsigned short i=0; i<numAnimUnits; i++) {
			if (params[i]) {
				float param = params[i];
				float *pweights = pAnimUnits[i].pWeights;
				for (unsigned short j=0; j<pAnimUnits[i].num_vertices; j++) {
					int index = 3 * pAnimUnits[i].pIndices[j];
					pframevert[index++] += param * *(pweights++);
					pframevert[index++] += param * *(pweights++);
					pframevert[index]	+= param * *(pweights++);
				}
			}
		}
	}
}

void FaceModel::ScaleFrameTimes(float factor) {
	for (unsigned long i=0; i<numFrames; i++)
		pFrameTimes[i] *= factor;
}


void FaceModel::ScaleFrameTimes(const char *filepath)
{	
	ENTimeTransform ttransform;

	float length = ttransform.initFromDurationTier(filepath);
	for(unsigned long i=0; i<numFrames; i++) {
	//	cout << pFrameTimes[i];
		pFrameTimes[i] = ttransform.transformTime(length*pFrameTimes[i]);
	}
}