//Arman Savran, 2005
//eNTERFACE'05


#pragma once

#include "DeformUnit.h"


typedef DeformUnit AnimUnit;
typedef DeformUnit ShapeUnit;



class FaceModel
{
public:
	enum RENDERMODE
	{
		SMOOTHSHADED,
		FLATSHADED,
		WIREFRAME,
		POINTS
	};

public:
	FaceModel(void);
	~FaceModel(void);

	void Clear();
	short ReadModel(const char *filepath);
	short ReadVRMLAnim(const char *filepath);
	void MakeOriginal();
	void Deform(unsigned long frame_no);
	
	void SetFPS(float val);
	bool AllocFrames(unsigned long num_frames);
	void CalcFrameCoords(unsigned long frameno, const float *params);
	void SetRenderMode(RENDERMODE mode);
	
	int GetState() const { return state; }
	unsigned short GetNumAnimUnits() const { return numAnimUnits; }
	int GetAnimUnitIndex(const char *name) const;
	float GetFrameTime(unsigned long frame_no) const { return frame_no>=numFrames ? -1 : pFrameTimes[frame_no]; }
	void ScaleFrameTimes(float factor);
	void ScaleFrameTimes(const char *filepath);
	unsigned long GetNumFrames() const { return numFrames; }
	float GetFPS() const { return fps; }

	void RenderGL();

private:
	void ComputeNormals();
	void (*pApplyRenderMode)();

private:	
	int state; //0,  -1, 1

	unsigned long numVertices;
	FaceIndex numTriangles;
	unsigned short numAnimUnits;
	unsigned short numShapeUnits;

	float *pVertices, *pOrgVertices;
	FaceIndex *pIndices;
	float *pVerNormals, *pTriNormals;
	AnimUnit *pAnimUnits;
	ShapeUnit *pShapeUnits;

	//animation data
	float fps;
	unsigned long numFrames;
	float *pVertSeq;
	float *pFrameTimes;

	RENDERMODE rendermode;
};