//Arman Savran, 2005
//eNTERFACE'05

#include "SeqGenerator.h"
#include "buffer.h"
#include <fstream>
#include <string>
#include <cmath>

#include <iostream>

using namespace std;

#define TMPSIZE 100


SeqGenerator::SeqGenerator(void)
	: num_emotions(0)//, pEmotions(0)
	, num_labels(0), pEndTimes(0), pLabels(0)
{	
	for (int i=0; i<Emotion::numEmotionTypes; i++)
		EmotionPtrs[i] = NULL;
}

SeqGenerator::~SeqGenerator(void)
{
	Clear();
}


void SeqGenerator::Clear()
{
	//DEL_DYNARRAY(pEmotions);
	for (int i=0; i<Emotion::numEmotionTypes; i++) {
		delete EmotionPtrs[i];
		EmotionPtrs[i] = 0;
	}
	num_emotions = 0;
	DEL_DYNARRAY(pEndTimes);
	DEL_DYNARRAY(pLabels);
	num_labels = 0;
}



short SeqGenerator::ReadEmotionData(const char *filepath, const FaceModel& face)
{
	Clear();

	ifstream ifs(filepath, ios::in);
	if (!ifs)
		return 2;


	try {
		char temp[TMPSIZE];
		string str;
	    //Check the Emotions file		
		ifs >> str;
		if (str != "#Emotions") { //wrong Emotions file
			ifs.close();
			return 4;
		}

		ifs >> num_emotions;
		if (num_emotions > 0 && num_emotions <= Emotion::numEmotionTypes) {

			//pEmotions = new Emotion[num_emotions];
			
		
			int e=0;
			//Emotion *pem = pEmotions;
			Emotion *pem;
			while (ifs.good() && e<num_emotions) {				
				ifs.getline(temp, TMPSIZE);
						
				//if (strcmp(temp, "##Neutral") == 0)
				//	pem->type = Emotion::NEUTRAL;				
				//else if (strcmp(temp, "##Happiness") == 0)
				//	pem->type = Emotion::HAPPINESS;
				//else if (strcmp(temp, "##Surprise") == 0)
				//	pem->type = Emotion::SURPRISE;
				//else if (strcmp(temp, "##Disgust") == 0)
				//	pem->type = Emotion::DISGUST;
				//else if (strcmp(temp, "##Sadness") == 0)
				//	pem->type = Emotion::SADNESS;
				//else if (strcmp(temp, "##Fear") == 0)
				//	pem->type = Emotion::FEAR;
				//else if (strcmp(temp, "##Anger") == 0)
				//	pem->type = Emotion::ANGER;
				//else			
				//	continue;

				Emotion::EMOTION etype;
				if (strcmp(temp, "##Neutral") == 0)
					etype = Emotion::NEUTRAL;					
				else if (strcmp(temp, "##Happiness") == 0)
					etype = Emotion::HAPPINESS;
				else if (strcmp(temp, "##Surprise") == 0)
					etype = Emotion::SURPRISE;
				else if (strcmp(temp, "##Disgust") == 0)
					etype = Emotion::DISGUST;
				else if (strcmp(temp, "##Sadness") == 0)
					etype = Emotion::SADNESS;
				else if (strcmp(temp, "##Fear") == 0)
					etype = Emotion::FEAR;
				else if (strcmp(temp, "##Anger") == 0)
					etype = Emotion::ANGER;
				else			
					continue; 
				
				//cout << "\n" << temp << endl;

				pem = new Emotion;
				EmotionPtrs[etype] = pem;

				e++;

						
				ifs >> pem->num_expressions;
				if (pem->num_expressions <= 0)
					continue;

				pem->pExpressions = new Expression[pem->num_expressions];

				ifs.getline(temp, TMPSIZE);
				ifs.getline(temp, TMPSIZE);

				Expression *pex = pem->pExpressions;
				int k=0;
				while (ifs.good() && k<pem->num_expressions) {					
					ifs.getline(temp, TMPSIZE);
				
					if (strcmp(temp, "#Open mouth") == 0)
						pex->exp_state = Expression::OPENEDMOUTH;
					else if (strcmp(temp, "#Closed mouth") == 0)
						pex->exp_state = Expression::CLOSEDMOUTH;
					else if (strcmp(temp, "#Pressed lips") == 0)
						pex->exp_state = Expression::PRESSEDLIPS;
					else if (strcmp(temp, "#Half opening") == 0)
						pex->exp_state = Expression::HALFOPENEDMOUTH;
					else
						continue;

					//cout << temp << endl;

					ifs >> pex->num_params;
					pex->pIndices = new unsigned short[pex->num_params];
					pex->pParams = new float[pex->num_params];

					ifs.getline(temp, TMPSIZE);
					int i;
					for (i=0; i<pex->num_params && ifs.good(); i++) {
						ifs.getline(temp, TMPSIZE);
						int ind = face.GetAnimUnitIndex(temp);
						if (ind < 0)
							throw (short) 4;
						pex->pIndices[i] = ind;
						ifs >> pex->pParams[i];

						ifs.getline(temp, TMPSIZE);
					}
					if (i != pex->num_params) {
						//cout << i <<": \n" << temp << endl;
						throw (short) 4;
					}

					k++;
					pex++;
				}

				if (k != pem->num_expressions) {
					//cout << e << ")  " << k << "/" << pem->num_expressions << endl;
					throw (short) 4;
				}

				//pem++;
			}
		
//cout << "\n\n" << e << endl;

			if (e != num_emotions)
				throw (short) 4;
		}


		ifs.close();
	}
	catch(bad_alloc x) { //memory allocation error
		ifs.close();		
		return 1;
	}
	catch(short tval) {		
		ifs.close();
        return tval;
	}
	catch(...)	{		
		ifs.close();		
		return -1;        
	}
	

	return 0;
}


short SeqGenerator::ReadTimeLabels(const char *filepath)
{
	DEL_DYNARRAY(pEndTimes);
	DEL_DYNARRAY(pLabels);
	num_labels = 0;

	ifstream ifs(filepath, ios::in);
	if (!ifs)
		return 2;


	try {
		ifs >> num_labels;
		if (num_labels > 0) {
			pLabels = new char[num_labels];
			pEndTimes = new float[num_labels];

			int k=0;
			while (ifs.good() && k<num_labels) {
				ifs >> pLabels[k];
				ifs >> pEndTimes[k];
				k++;
			}
		}

		ifs.close();
	}
	catch(bad_alloc x) { //memory allocation error
		ifs.close();		
		return 1;
	}
	catch(...)	{		
		ifs.close();		
		return -1;        
	}

	return 0;
}



Expression::EXPRESSIONSTATE SeqGenerator::GetExpression(char label) const
{
	switch (label) {
		case 'X':
			return Expression::CLOSEDMOUTH;
		case 'M':
			return Expression::PRESSEDLIPS;
		case 'A':
			return Expression::OPENEDMOUTH;

		default:
			return Expression::CLOSEDMOUTH;
	}
}

#define USIGMOID 3//6.91 //value that makes sigmoid = 0.999 (~1)
inline float sigmoid(float x)
{
	return (float) 1 / (1 + exp(-x));
}

int SeqGenerator::Generate(FaceModel *pFace, Emotion::EMOTION em) const
{
	//Parameter for maximum silence transition
	const float MaxSil = 0.35f;
	//Parameters for transition regions of the sound /a/
	const float trsegment_ratios[2] = {0.45, 0.45};
	if (trsegment_ratios[0] + trsegment_ratios[1] >= 0.99f)
		return 2;

	if (EmotionPtrs[em] == NULL)
		return 1;

	float length = pEndTimes[num_labels-1];
	float fps = pFace->GetFPS();
	unsigned long numframes = (unsigned long) (fps * length);

	//cout << length << endl;
	//cout << fps << endl;
	//cout << numframes << endl;
	//cout << endl;

	float *frameWeights = 0;
	float *params = 0;
	unsigned short numParams = pFace->GetNumAnimUnits();
	try {
		InitBuffer((void *&) frameWeights, Expression::numExpressions*numframes*sizeof(float));
		InitBuffer((void *&) params, numParams*sizeof(float));
		pFace->AllocFrames(numframes);
	}
	catch (bad_alloc x) {
		DEL_DYNARRAY(frameWeights);
		DEL_DYNARRAY(params);
		return -1;
	}
	

	//Calculate a single weight for each frame for all the face motion parameters
	int labindex = 0;
	bool newlabel = true;
	float startTime = 0.0f;	
	float sigmoid_pos[2], sigmoid_scale[2];
	float segendtimes[2];
	//char prelabel = 0;

	float *pfw = frameWeights;	
	for (unsigned long i=0; i<numframes; i++, pfw+=Expression::numExpressions) {
		//cout << (float)i/fps << "\n";
		float timepos = (float) i/fps;
		while ( timepos >= pEndTimes[labindex] && labindex != num_labels ) {
			startTime = pEndTimes[labindex];
			labindex++;
			newlabel = true;
		}

		switch (pLabels[labindex]) {
			case 'X':
				//pfw[Expression::CLOSEDMOUTH] = 1;
				//break;
				if (newlabel) { //prepare for smooth transition with sigmoid
					newlabel = false;
					float duration = pEndTimes[labindex] - startTime;
					if (duration > MaxSil) {
						if (labindex == 0)
							*sigmoid_pos = startTime + duration - 0.5f*MaxSil;
						else if (labindex == num_labels-1)
							*sigmoid_pos = startTime + 0.5f*MaxSil;
						*sigmoid_scale = (float) 6 / MaxSil;
					}
					else {
						*sigmoid_pos = startTime + 0.5f*duration;
						*sigmoid_scale = (float) 6 / duration;
					}
				}
				//sampling
				if (labindex == 0) //beginning
					pfw[Expression::CLOSEDMOUTH] = sigmoid(*sigmoid_scale * (timepos-*sigmoid_pos));
				else if (labindex == num_labels-1) //end
					pfw[Expression::CLOSEDMOUTH] = 1 - sigmoid(*sigmoid_scale * (timepos-*sigmoid_pos));
					
				break;
			case 'M':
				pfw[Expression::PRESSEDLIPS] = 1;
				break;
			case 'A':
				//pfw[Expression::OPENEDMOUTH] = 1;
				//break;
				if (newlabel) { //prepare for smooth transition with sigmoid
					//cout << "\n";
					newlabel = false;
					float duration = pEndTimes[labindex] - startTime;
					//calculate the sigmoid parameters
					float temp = 0.5f*trsegment_ratios[0]*duration;
					sigmoid_pos[0] = startTime + temp;
					sigmoid_scale[0] = (float) USIGMOID / temp;
					temp = 0.5f*trsegment_ratios[1]*duration;
					sigmoid_pos[1] = startTime + duration - temp;
					sigmoid_scale[1] = (float) USIGMOID / temp;

					segendtimes[0] = startTime + trsegment_ratios[0]*duration;
					segendtimes[1] = startTime + (1 - trsegment_ratios[1])*duration;
				}

				//sampling
				if (timepos < segendtimes[0]) { //enterance
					pfw[Expression::OPENEDMOUTH] = sigmoid(sigmoid_scale[0]*(timepos-sigmoid_pos[0]));
					if (labindex > 0)
						pfw[GetExpression(pLabels[labindex-1])] = 1 - pfw[Expression::OPENEDMOUTH];
				}
				else if (timepos < segendtimes[1]) { //steady state
					pfw[Expression::OPENEDMOUTH] = 1;		
				}
				else { //exit
					pfw[Expression::OPENEDMOUTH] = 1 - sigmoid(sigmoid_scale[1]*(timepos-sigmoid_pos[1]));
					if (labindex < num_labels-1)
						pfw[GetExpression(pLabels[labindex+1])] = 1 - pfw[Expression::OPENEDMOUTH];					
				}
				break;

			default:
				pfw[Expression::CLOSEDMOUTH] = 1;
				break;
		}

		//cout << pLabels[labindex] << ": ";
		//for (int n=0; n<Expression::numExpressions; n++)
		//	cout << pfw[n] << " ";
		//cout << endl;
		


		//weighted average of expressions for an emotion (calculate the parameters)
		memset(params, 0, numParams*sizeof(float));
		for (int k=0; k<Expression::numExpressions; k++) {
			Expression *pex = &EmotionPtrs[em]->pExpressions[k];
			//cout << pex->num_params << "\n" << endl;
			for (unsigned short j=0; j<pex->num_params; j++)
				params[pex->pIndices[j]] += pfw[pex->exp_state] * pex->pParams[j];	
		}

		//Calculate the coordinates
		pFace->CalcFrameCoords(i, params);

		////smooth transition at the silence 
		//if (labindex>0 && pLabels[labindex-1] == 'X') {
		//	for (int i=labindex-1; i>=0 && pLabels[i]=='X'; i--) {
		//	}

		//}
		//if (labindex+1<num_labels && pLabels[labindex+1] == 'X') {
		//	for (int i=labindex+1; i<num_labels && pLabels[i]=='X'; i++) {
		//	}
		//}

	}

	DEL_DYNARRAY(frameWeights);
	DEL_DYNARRAY(params);

	return 0;
}