//Arman Savran, 2005
//eNTERFACE'05


/* -- Include the precompiled libraries -- */
#ifdef WIN32
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")

#include <Windows.h>
#endif

#include "SDL.h"
#include "SDL_opengl.h"
#include "SDL_thread.h"

#include <iostream>

#include "FaceModel.h"
#include "SeqGenerator.h"


using namespace std;



#define WIDTH  640
#define HEIGHT 480


int g_mode;
FaceModel g_face;

SDL_AudioSpec g_wav_spec;
Uint32 g_wav_length;
Uint8 *g_wav_buffer;

SDL_mutex *g_audio_mutex = 0;
SDL_cond *g_audio_cond = 0;

GLfloat y_ang = 0;


struct AudioStreamInfo
{
	Uint8 *pos;
	Uint32 length;
};

AudioStreamInfo g_asinfo = {0, 0};

void audio_callbackfn(void *udata, Uint8 *stream, int len)
{	
	AudioStreamInfo *asinfo = (AudioStreamInfo *) udata;

	//if data left, copy to play
	if (asinfo->length) {
		len = (Uint32)len > asinfo->length ? asinfo->length : len;
		memcpy(stream, asinfo->pos, len);
		//SDL_MixAudio(stream, asinfo->pos, len, SDL_MIX_MAXVOLUME);

		SDL_CondSignal(g_audio_cond);
	
		asinfo->pos += len;
		asinfo->length -= len;
	}
	//else
	//	SDL_CloseAudio();
}


static void SetupSDL()
{
	const SDL_VideoInfo* video;

    if ( SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0 ) {
		std::cerr << "Couldn't initialize SDL: " << SDL_GetError() << "\n";
        exit(1);
    }
	
	//Clean up on exit
	atexit(SDL_Quit);


    video = SDL_GetVideoInfo( );
	
    if( !video ) {
		std::cerr << "Couldn't get video information: " << SDL_GetError() << "\n";
        exit(1);
    }

    /* Set the minimum requirements for the OpenGL window */
    SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

    /* Note the SDL_DOUBLEBUF flag is not required to enable double 
     * buffering when setting an OpenGL video mode. 
     * Double buffering is enabled or disabled using the 
     * SDL_GL_DOUBLEBUFFER attribute.
     */
    if( (SDL_SetVideoMode(WIDTH, HEIGHT, video->vfmt->BitsPerPixel, SDL_OPENGL|SDL_RESIZABLE)) == 0 ) {
		std::cerr << "Couldn't set video mode: " << SDL_GetError() << "\n";
        exit(1);
    }
	//g_bitsperpixel = video->vfmt->BitsPerPixel;
}


static void OnSize(int w, int h)
{
    glViewport(0, 0, (GLsizei) w, (GLsizei) h);
	//Change to the projection matrix in order to set our viewing volume.
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	GLdouble fovy = 60;
	if (g_mode == 2)		fovy = 30;	
	gluPerspective(fovy, (GLdouble) w/h, 0.1, 10000.0);
	glMatrixMode( GL_MODELVIEW );
}

static void InitGL(int w, int h)
{
	//Background
	glClearColor(0.0f, 0.5f, 0.6f, 0);	

	// Lighting
	GLfloat light_diffuse[] = {1.0, 1.0, 1.0, 1.0};
	glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
	glLightfv(GL_LIGHT0, GL_AMBIENT, light_diffuse);

	//GLfloat light_position[] = { 0.0, 0.0, -1.0, 0.0 };	
	GLfloat light_position[] = { -20, 19, -15, 1 };
	if (g_mode == 2) {
		light_position[0] = 0.0f;
		light_position[1] = 0.0f;
		light_position[2] = -1.0f;
		light_position[3] = 0.0f;
	}
	
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);

    glEnable(GL_DEPTH_TEST);
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);

    // Culling.
    //glCullFace( GL_BACK );
    //glFrontFace( GL_CCW );
    //glEnable( GL_CULL_FACE );

	OnSize(w, h);
}

static void Render()
{
    /* clear color and depth buffers */
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);


	/* position viewer */
    glMatrixMode(GL_MODELVIEW);

	glLoadIdentity();

	if (g_mode == 1)
		glTranslatef(0.0f, 0.0f, -2.0f);
	else
		//glTranslatef(-344.000121f, +217.542839f, -683.222417f);
		glTranslatef(-380.080558, 326.372179, -720.122574);


	glRotatef(y_ang, 0, 1, 0);
	g_face.RenderGL();
	

	SDL_GL_SwapBuffers();
}


//void StartAudio(Uint32 *pstarttime)
//{
//	static AudioStreamInfo asinfo;
//	asinfo.pos = g_wav_buffer;
//	asinfo.length = g_wav_length;
//
//	g_wav_spec.userdata = &asinfo;
//	g_wav_spec.callback = audio_callbackfn;	
//
//
//	//Open the audio device
//
//	//if (SDL_GetAudioStatus() != SDL_AUDIO_STOPPED) {
//	//	SDL_CloseAudio();
//	//	SDL_Delay(100);
//	//}
//
//	//SDL_CloseAudio();
//	if (SDL_OpenAudio(&g_wav_spec, NULL) < 0) {
//		cerr << "Could not open audio: " << SDL_GetError() << endl;
//		exit(-1);
//	}
//
//	SDL_PauseAudio(0);
//	*pstarttime = SDL_GetTicks();
//}


void StartAudio(Uint32 *pstarttime)
{
	SDL_LockAudio();	
	g_asinfo.pos = g_wav_buffer;
	g_asinfo.length = g_wav_length;
	SDL_UnlockAudio();

	SDL_LockMutex(g_audio_mutex);
	SDL_CondWait(g_audio_cond, g_audio_mutex);
	//Uint32 t = SDL_GetTicks();
	//SDL_Delay(100);
	//Wait for second transfer
	SDL_LockMutex(g_audio_mutex);
	SDL_CondWait(g_audio_cond, g_audio_mutex);
	*pstarttime = SDL_GetTicks();

	//cout << *pstarttime - t << endl;
} 

void StopAudio()
{
	SDL_LockAudio();
	g_asinfo.length = 0;
	SDL_UnlockAudio();
}


void OpenAudio()
{
	g_wav_spec.userdata = &g_asinfo;
	g_wav_spec.callback = audio_callbackfn;	

	//Open the audio device
	if (SDL_OpenAudio(&g_wav_spec, NULL) < 0) {
		cerr << "Could not open audio: " << SDL_GetError() << endl;
		exit(-1);
	}

	SDL_PauseAudio(0);
}

static void MainLoop()
{
	SDL_Event event;
	int do_anim = 0;
	
	Uint32 start_time, now;
	unsigned long pre_frame, cur_frame;

	while(1) {
		// process pending events
		while(SDL_PollEvent(&event)) {
			switch(event.type) {

				case SDL_KEYDOWN:
					switch (event.key.keysym.sym) {
						case SDLK_RIGHT:
							y_ang += 3;
							Render();
							break;
						case SDLK_LEFT:
							y_ang -= 3;
							Render();
							break;

						case SDLK_SPACE:
							if (!do_anim) {
								pre_frame = 999999;
								cur_frame = 0;
								do_anim = g_mode;
								StartAudio(&start_time);
							}
							break;
						case SDLK_BACKSPACE:
							//SDL_PauseAudio(1);
							g_face.MakeOriginal();
							Render();
							StopAudio();
							do_anim = 0;							
							break;

						case SDLK_ESCAPE:
							exit(0);
					}
					break;

				case SDL_VIDEOEXPOSE:
					if (do_anim == 0)
						Render();
					break;

				case SDL_VIDEORESIZE:
					SDL_SetVideoMode(event.resize.w, event.resize.h, 0, SDL_OPENGL|SDL_RESIZABLE);
					InitGL(event.resize.w, event.resize.h);
					if (do_anim == 0)
						Render();
					break;

				case SDL_QUIT:
					exit(0);
			}

		}


		if (do_anim == 1) {
//cout << start_time << "   -   " << g_astime << endl;
			now = SDL_GetTicks();
			cur_frame = (unsigned long) ((float) (now - start_time) * g_face.GetFPS()) / 1000;
			//cout << (now - start_time) << "  " << cur_frame << endl;
			if (cur_frame == pre_frame)
				SDL_Delay( (Uint32) ((1000*(cur_frame+1))/g_face.GetFPS()) + start_time - now );
			else if (cur_frame >= g_face.GetNumFrames()) {
					g_face.MakeOriginal();
					Render();
					StopAudio();
					do_anim = 0;
					cout << "Finished!" << endl;
			}
			else {
				//int n_missed = cur_frame - pre_frame - 1;
				//if (n_missed < 0)	n_missed = 0; //for the initial frame
				//cout << n_missed << endl;

				g_face.Deform(cur_frame);

				Render();
				//y_ang += 1;
				pre_frame = cur_frame;
			}


		}
		else if (do_anim == 2)  {

			now = SDL_GetTicks();
			Uint32 etime = now - start_time;
			float t_next;

			while ( (t_next = 1000*g_face.GetFrameTime(cur_frame+1)) >= 0) {
				if (etime < t_next)
					break;
				else
					cur_frame++;
			}

			if (t_next < 0) {
				g_face.MakeOriginal();
				Render();
				StopAudio();
				do_anim = 0;
				cout << "Finished!" << endl;
			}

			if (cur_frame == pre_frame) {
				if (t_next > etime)
					SDL_Delay((Uint32)t_next - etime);
			}
			else {
				g_face.Deform(cur_frame);
				Render();
				pre_frame = cur_frame;
			}
		}
		else
			SDL_Delay(30);
		
	}

}

void ClearAudio(void)
{
	SDL_CloseAudio();
	SDL_FreeWAV(g_wav_buffer);
	if(g_audio_mutex) SDL_DestroyMutex(g_audio_mutex);
	if(g_audio_cond)  SDL_DestroyCond(g_audio_cond);
}


void CheckFileReadResult(short res, const char *filename)
{
	char *errorMsg[] = {"Memory allocation error!",
					"File could not be opened!",
					"File read error!",
					"Incorrect file!"};

	if (res) {
		if (res < 0)
			cerr << filename << " : " << errorMsg[2] << endl;
		else
			cerr << filename << " : " << errorMsg[res-1] << endl;
		exit(res);
	}
}

int main(int argc, char **argv)
{
#ifdef WIN32
	SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
#endif


	//cout << argc << endl;

	Emotion::EMOTION etype = Emotion::NEUTRAL;
	if (argc == 3) {
		g_mode = atoi(argv[1]);
		g_mode = 1;
	/*	if (g_mode != 1 || g_mode != 2) {
			cout << "First argument should be 1 for 'mama...', 2 for tracking animation" << endl;
			exit(0);
		}*/
		if (strcmp(argv[1], "Neutral") == 0)
			etype = Emotion::NEUTRAL;
		else if (strcmp(argv[2], "Happiness") == 0)
			etype = Emotion::HAPPINESS;
		else if (strcmp(argv[2], "Surprise") == 0)
			etype = Emotion::SURPRISE;
		else if (strcmp(argv[2], "Disgust") == 0)
			etype = Emotion::DISGUST;
		else if (strcmp(argv[2], "Sadness") == 0)
			etype = Emotion::SADNESS;
		else if (strcmp(argv[2], "Fear") == 0)
			etype = Emotion::FEAR;
		else if (strcmp(argv[2], "Anger") == 0)
			etype = Emotion::ANGER;
	}
	else {
		cout << "Not enough arguments!" << endl;
		exit(0);
	}
	//etype = Emotion::HAPPINESS;

	g_mode = 1;
	

	//Setup SDL	
	SetupSDL();
	SDL_WM_SetCaption("Emotional Caricatural Mirror", "EmCarMir");

	//Init openGL
	InitGL(WIDTH, HEIGHT);


		

	string filename;
	if (g_mode == 1) {
		// Read model
		filename = "candide3.wfm";
		CheckFileReadResult(g_face.ReadModel(filename.c_str()), filename.c_str());
		
		SeqGenerator seqgen;
		// Read emotion database
		CheckFileReadResult(seqgen.ReadEmotionData("emotions.txt", g_face), "emotions.txt");

		// Read time labels
		//filename = "../data/output.max";
		filename = "ma.max";
		CheckFileReadResult(seqgen.ReadTimeLabels(filename.c_str()), filename.c_str());

		// Generate the sequence
		g_face.SetFPS(25);
		switch (seqgen.Generate(&g_face, etype)) {
			case 1:
				cerr << "Given emotion is not available!" << endl;
				exit(1);			
			case -1:
				cerr << "Memory allocation error!" << endl;
				exit(-1);
		}

		char *wav_filepath = "audiostream_out.wav";

		SDL_FreeWAV(g_wav_buffer);
		if (SDL_LoadWAV(wav_filepath, &g_wav_spec, &g_wav_buffer, &g_wav_length) == NULL) {
			cerr << "Could not open '" << wav_filepath << "'. " << SDL_GetError() << endl;
			exit(-1);
		}
	}
	else if (g_mode == 2){
		//filename = "S01_DI.wrl";		
		filename = "tracked.wrl";
		CheckFileReadResult(g_face.ReadVRMLAnim(filename.c_str()), filename.c_str());
		g_face.ScaleFrameTimes("audiostream_out.dut");
		char *wav_filepath = "audiostream_out.wav";

		SDL_FreeWAV(g_wav_buffer);
		if (SDL_LoadWAV(wav_filepath, &g_wav_spec, &g_wav_buffer, &g_wav_length) == NULL) {
			cerr << "Could not open '" << wav_filepath << "'. " << SDL_GetError() << endl;
			exit(-1);
		}
	}
	else {
		cerr << "Unknown mode!" << endl;
		exit(0);
	}
	

	//Read audio
	//char *wav_filepath = "../data/output.wav";
	//char *wav_filepath = "../data/ma_long_out.wav";
	//char *wav_filepath = "../data/audiostream_out.wav";

	//SDL_FreeWAV(g_wav_buffer);
	//if (SDL_LoadWAV(wav_filepath, &g_wav_spec, &g_wav_buffer, &g_wav_length) == NULL) {
	//	cerr << "Could not open '" << wav_filepath << "'. " << SDL_GetError() << endl;
	//	exit(-1);
	//}
	atexit(ClearAudio);
	

	OpenAudio();
	AudioStreamInfo *pasinfo = (AudioStreamInfo *) g_wav_spec.userdata;

	g_audio_mutex = SDL_CreateMutex();
	g_audio_cond = SDL_CreateCond();
	
	//Enter loop
	MainLoop();

	return 0;
}