% IVI Configuration Store Object Functions and Properties.
%
% IVI Configuration Store object construction.
%   iviconfigurationstore - Construct IVI configuration store object.
%
% Getting and setting parameters.
%   get                   - Get value of IVI configuration store object
%                           property.
%   set                   - Set value of IVI configuration store object
%                           property. 
%
% Updating IVI Configuration Store parameters.
%   add                   - Add entry to IVI configuration store object.
%   commit                - Save IVI configuration store object.
%   remove                - Remove entry from IVI configuration store object.
%   update                - Update entry in IVI configuration store object.
%
% IVI Configuration Store object properties.
%   ActualLocation        - Configuration store file used by IVI
%                           configuration store object.
%   DriverSessions        - Collection of driver sessions contained
%                           in configuration store.
%   HardwareAssets        - Collection of hardware assets contained 
%                           in configuration store.
%   LogicalNames          - Collection of logical names contained in
%                           configuration store.
%   MasterLocation        - Full pathname of master configuration store
%                           file.
%   Name                  - Name of IVI Configuration Server.
%   ProcessLocation       - Configuration store file to be used by this
%                           process, if not the master store.
%   PublishedAPIs         - Collection of published APIS contained in
%                           configuration store.
%   Revision              - IVI Configuration Server version.
%   ServerDescription     - IVI Configuration Server description.
%   Sessions              - Collection of driver sessions contained in 
%                           configuration store. 
%   SoftwareModules       - Collection of software modules contained
%                           in configuration store.
%   SpecificationVersion  - Version of IVI Configuration Server
%                           specification to which this revision complies.
%   Vendor                - IVI Configuration Server vendor.
%
% See also IVICONFIGURATIONSTORE.
%

%   MP 9-30-03
%   Copyright 1999-2004 The MathWorks, Inc. 
%   $Revision: 1.1.6.3 $  $Date: 2004/02/01 21:55:03 $
