function isMutable = privateVerifyIsMutableEntry(typeName)
%PRIVATEISMUTABLEENTRY Returns whether the user allowed to change this entry type.
% 
%   PRIVATEISMUTABLEENTRY(TYPE) returns true if TYPE is a user-configurable
%   entry type in the IVI configuration store. TYPE is case-sensitive.
%
%   This function should not be called directly by the user. 

%   PE 10-01-03
%   Copyright 1999-2004 The MathWorks, Inc. 
%   $Revision: 1.1.6.3 $  $Date: 2004/12/01 20:12:16 $

error(nargchk(1, 1, nargin));

isMutable = false;

if any(strcmp(typeName, {'DriverSession', 'HardwareAsset', 'LogicalName'}))
    isMutable = true;
end
