function prefspanel
%PREFSPANEL Registers an Instrument Control preferences control panel.
% 
%   PREFSPANEL registers a Preferences Control panel for object's in the Instrument
%   Control Toolbox with the MATLAB IDE.
%

%   MP 11-03-01
%   Copyright 1999-2004 The MathWorks, Inc. 
%   $Revision: 1.2.4.7 $  $Date: 2004/01/16 20:01:43 $


% Register Object-based context menus items in the Workspace Browser.

%   Methods of MatlabObjectMenuRegistry are unsupported.  Calls to these
%   methods will become errors in future releases.

% Define Serial Port Context menu
com.mathworks.mlwidgets.workspace.MatlabCustomClassRegistry.registerClassCallbacks(...
    {'serial'},...
    'Explore',...
    {'Display Summary', ...
	'Call Property Inspector',...
	'-',...
	'Display Hardware Info', ...
	'-', ...
	'Instrument Help'},...
    {'disp($1)', ...
	'inspect($1);', ...
	'',...
	'instrhwinfo($1); disp(ans)',...
	'-',...
	'instrhelp($1)'});

% Define icinterface, device and output objects - same as serial port.
com.mathworks.mlwidgets.workspace.MatlabCustomClassRegistry.registerSimilarClassCallbacks(...
    {'gpib', 'visa', 'tcpip', 'udp', 'icdevice'}, 'serial');

% Define Instrument Context menu
com.mathworks.mlwidgets.workspace.MatlabCustomClassRegistry.registerClassCallbacks(...
    {'instrument'},...
    'Explore',...
    {'Display Summary', ...
	'Call Property Inspector',...
	'-',...
	'Instrument Help'},...
    {'display($1)', ...
	'inspect($1);', ...
	'',...
	'help instrument\Contents'});

% Define output object array - same as instrument.
com.mathworks.mlwidgets.workspace.MatlabCustomClassRegistry.registerSimilarClassCallbacks({'icgroup'}, 'instrument');
