function out = privateGetHelp(name)
%PRIVATEGETHELP returns help for functions that don't exist.
%
%   OUT=PRIVATEGETHELP('NAME') returns the help for function,
%   NAME, to OUT. The function NAME does not have an Instrument
%   Control M-file associated with it but does have Instrument
%   Control specific information, e.g. CLEAR, SAVE and LOAD.
%
%   This is a helper function for INSTRHELP. This function 
%   should not be called directly by users.
%

%   MP 10-23-03
%   Copyright 1999-2004 The MathWorks, Inc. 
%   $Revision: 1.1.6.3 $  $Date: 2004/01/16 20:02:42 $

out = '';

if strcmpi(name, 'clear')
    out = [' CLEAR Remove instrument or device group object from the workspace.\n',...
    '   \n',...
    '   CLEAR OBJ removes the instrument object or device group object, OBJ, \n',...
    '   from the MATLAB workspace. If the instrument object has a Status  \n',...
    '   property value of open, the instrument object will remain connected  \n',...
    '   to the instrument.\n',...
    '   \n',...
    '   Cleared objects can be restored to the MATLAB workspace with the\n',...
    '   INSTRFIND function.\n',...
    '   \n',...
    '   The FCLOSE function is used to disconnect an interface object\n',...  
    '   from the instrument. The DISCONNECT function is used to disconnect\n',...
    '   a device object from the instrument. To remove OBJ from memory use\n',...
    '   the DELETE function.\n',...
    '   \n',...
    '   Example:\n',...
    '       g = gpib(''ni'', 0, 1);\n',...
    '       clear g\n',...
    '       g = instrfind;\n',...
    '   \n',... 
    '   See also ICDEVICE/DISCONNECT, ICINTERFACE/FCLOSE, INSTRUMENT/INSTRFIND,\n',...
    '   INSTRUMENT/DELETE, INSTRHELP.\n',...
    '\n'];
elseif strcmpi(name, 'load')
    out = [' LOAD Load instrument or device group objects into the MATLAB workspace.\n',...
    ' \n',...
    '   LOAD FILENAME returns all variables from the MAT-file, FILENAME,\n',...
    '   into the MATLAB workspace.\n',...
    ' \n',...
    '   LOAD FILENAME OBJ1 OBJ2 ... returns the specified instrument objects \n',...
    '   or device group objects, OBJ1, OBJ2,... from the MAT-file, FILENAME, \n',...
    '   into the MATLAB workspace.\n',...
    ' \n',...
    '   S = LOAD(''FILENAME'',''OBJ1'',''OBJ2'',...) returns the structure, S, with\n',...
    '   the specified instrument or device group objects, OBJ1, OBJ2,... from the \n',...
    '   MAT-file, FILENAME, instead of directly loading the objects into the \n',...
    '   workspace. The fieldnames in S match the names of the objects that were\n',...
    '   retrieved. If no objects are specified, then all variables existing in \n',...
    '   the MAT-file are loaded.\n',...
    ' \n',...
    '   Values for read-only properties will be restored to their default values\n',...
    '   upon loading. For example, the Status property will be restored to \n',...
    '   closed. PROPINFO can be used to determine if a property is read-only.\n',...
    ' \n',...
    '   Examples:\n',...
    '       s = serial(''COM1'');\n',...
    '       set(s, ''Parity'', ''Mark'', ''DataBits'', 7);\n',...
    '       save fname s\n',...
    '       load fname\n',...
    '       load(''fname'', ''s'');\n',...
    ' \n',...
    '   See also INSTRHELP, INSTRUMENT/PROPINFO.\n',...
    '\n'];
elseif strcmpi(name, 'save')
    out = [' SAVE Save instrument or device group objects to a MAT-file.\n',...
    ' \n',...
    '   SAVE FILENAME saves all variables in the MATLAB workspace to the \n',...
    '   specified MAT-file, FILENAME. If an extension is not specified for \n',...
    '   FILENAME, then a .MAT extension is used.\n',...
    ' \n',...
    '   SAVE FILENAME OBJ1 OBJ2 ... saves instrument objects or device group \n',...
    '   objects, OBJ1, OBJ2,... to the specified MAT-file, FILENAME. If an \n',...
    '   extension is not specified for FILENAME, then a .MAT extension is used.\n',...
    ' \n',...
    '   SAVE can be used in the functional form as well as the command form \n',...
    '   shown above. When using the functional form, you must specify the \n',...
    '   file name and objects as strings.\n',...
    ' \n',...
    '   Any data associated with the instrument object will not be stored\n',...
    '   in the MAT-file. The data can be brought into the MATLAB workspace\n',...
    '   with one of the synchronous read functions and then saved to the\n',...
    '   MAT-file using a separate variable name. \n',...
    ' \n',...
    '   The LOAD command is used to return variables from the MAT-file to\n',...
    '   the MATLAB workspace. Values for read-only properties will be restored \n',...
    '   to their default values upon loading. For example, the Status property\n',...
    '   will be restored to closed. PROPINFO can be used to determine if a\n',...
    '   property is read-only.\n',...
    '\n',...
    '   Examples:\n',...
    '       s = serial(''COM1'');\n',...
    '       set(s, ''BaudRate'', 2400, ''StopBits'', 1);\n',...
    '       save fname s\n',...
    '       set(s, ''BytesAvailableFcn'', {''mycallback'', 5});\n',...
    '       save(''fname1'', ''s'')\n',...
    ' \n',...
    '   See also INSTRHELP, INSTRUMENT/PROPINFO, ICINTERFACE/RECORD, \n',...
    '   ICINTERFACE/FREAD, ICINTERFACE/FSCANF, ICINTERFACE/FGETS,\n',...
    '   ICINTERFACE/FGETL.\n',...
    '\n'];
end
