function value = privatePlatformProperty(prop)
%PRIVATEPLATFORMPROPERTY return platform information.
%
%   PRIVATEPLATFORMPROPERTY(PROP) returns platform specific values for a given
%   property, PROP.
%
%   This function should not be called directly by the user.
%  
 
%   PE 08-16-04
%   Copyright 2004 The MathWorks, Inc. 
%   $Revision: 1.1.8.1 $  $Date: 2004/12/01 20:12:46 $

value = '';

switch(prop)
    case 'dirname'
        switch computer
            case 'PCWIN'
                value = 'win32';
            case 'GLNX86'
                value = 'glnx86';
            case 'GLNXA64'
                value = 'glnxa64';
            case 'SOL2'
                value = 'sol2';
            case 'MAC'
                value = 'mac';
        end
    case 'libext'
        switch computer
            case 'PCWIN'
                value = '.dll';
            case {'GLNX86', 'GLNXA64', 'SOL2'}
                value = '.so';
            case 'MAC'
                value = '.dylib';
        end
end
