function varargout = ICBSupport(command, varargin);

%   PE 01-06-03
%   Copyright 2003-2004 The MathWorks, Inc. 
%   $Revision: 1.1.6.3 $  $Date: 2004/07/30 02:17:10 $

persistent blockList;

mlock;

switch (lower(command))
case 'open'
    blockH = get_param(gcbh, 'Handle');
    
    % If the dialog for this block already exists, simply bring to the front.
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == blockH);
        if ~isempty(idx)
            %disp('Block dialog already exists.');
            blockList(idx).data.frame.show;
            return;
        end
    end
    
    % If the dialog does not already exist, create it.
    switch (varargin{1})
    case 'query'
        frame = handle(com.mathworks.toolbox.instrument.icb.QueryFrame);
    case 'send'
        frame = handle(com.mathworks.toolbox.instrument.icb.SendFrame);
    end
    
    frame.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
    frame.setTitle(['Block Parameters: ' get_param(blockH, 'Name')]);
    data.frame = frame;
    
    u = get_param(blockH, 'uddobject');
    list = handle.listener(u, 'PropertyPostSet', {@localPropertyPostSetCallback, blockH});
    data.objectListener = list;
        
    button = handle(frame.applyButton);
    data.apply = button;
    list = handle.listener(button, 'ActionPerformed', {@localApplyCallback, blockH});
    data.applyListener = list;

    button = handle(frame.cancelButton);
    data.cancel = button;
    list = handle.listener(button, 'ActionPerformed', {@localCancelCallback, blockH});
    data.cancelListener = list;

    button = handle(frame.helpButton);
    data.help = button;
    list = handle.listener(button, 'ActionPerformed', {@localHelpCallback, blockH});
    data.helplListener = list;

    button = handle(frame.okButton);
    data.ok = button;
    list = handle.listener(button, 'ActionPerformed', {@localOKCallback, blockH});
    data.okListener = list;
    
    [params, values] = localGetMaskValues(blockH);

    blockList(end + 1).blockHandle = blockH;
    blockList(end).data = data;
    blockList(end).lastValues = values;
    
    localUpdateJavaDialog(blockList(end), params, values, true);

    % If the user opens the model while the simulation is running, we need to make
    % sure the non-tunable parameters are disabled.
    if (strcmp(lower(get_param(localGetModel(blockH), 'SimulationStatus')), 'running') == 1)
        frame.disableComponents;
    end
    
    frame.show;
    
case {'delete'}
    blockH = get_param(gcbh, 'Handle');
    
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == blockH);
        if ~isempty(idx)
            blockList(idx).data.frame.hide;
            blockList(idx) = [];
        end
    end
    
case 'start'
    blockH = get_param(gcbh, 'Handle');    
    
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == blockH);
        if ~isempty(idx)
            if (blockList(idx).data.frame.applyButton.isEnabled == true)
                error(['Block has unapplied changes.  Please apply or cancel these changes before running the simulation.']);
            end
            blockList(idx).data.frame.disableComponents;
        end
    end
    
case 'stop'
     blockH = get_param(gcbh, 'Handle');
    
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == blockH);
        if ~isempty(idx)
            blockList(idx).data.frame.enableComponents;
        end
    end
   
case 'namechange'
    blockH = get_param(gcbh, 'Handle');
    
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == blockH);
        if ~isempty(idx)
            blockList(idx).data.frame.setTitle(['Block Parameters: ' get_param(blockH, 'Name')]);
        end
    end

case 'getblockdata'
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == varargin{1});
        if ~isempty(idx)
            varargout(1) = {blockList(idx)};
        else
            varargout{1} = {[]};
        end
    else
        varargout(1) = {[]};
    end

case 'setblockdata'
    if ~isempty(blockList)
        idx = find([blockList.blockHandle] == varargin{1});
        if ~isempty(idx)
            blockList(idx).lastValues = varargin{2};
        end
    end
        
otherwise
    disp(['Unknown command: ' command]);
end

%
%   localUpdateJavaDialog
%
function localUpdateJavaDialog(blockData, params, values, disableApply)

blockData.data.frame.setParameterValues(params, values);

if (disableApply)
    blockData.data.apply.setEnabled(false);
end

%
%   localWindowClosingCallback
%
function localWindowClosingCallback(obj, event)

%
%   localApplyCallback
%
function localApplyCallback(obj, event, blockH)

localApply(blockH);

%
%   localCancelCallback
%
function localCancelCallback(obj, event, blockH)

params = localGetMaskValues(blockH);

blockData = ICBSupport('getblockData', blockH);

if ~isempty(blockData)
    blockData.data.frame.hide;
    localUpdateJavaDialog(blockData, params, blockData.lastValues, true);
end


%
%   localHelpCallback
%
function localHelpCallback(obj, event, blockH)
disp('Help');

%
%   localOKCallback
%
function localOKCallback(obj, event, blockH)

blockData = ICBSupport('getblockData', blockH);

if ~isempty(blockData)
    if (blockData.data.frame.applyButton.isEnabled == true)
        localApply(blockH);
    end
    blockData.data.frame.hide;
end

%
%   localGetMaskValues
%
function  [params, values] = localGetMaskValues(blk)

params = {};
values = {};

if( strcmp( get_param( blk,'Type' ), 'block' ) )
    
    if(strcmp(get_param(blk, 'Mask' ), 'on' ))
        params  = get_param(blk, 'MaskNames');
        values  = get_param(blk, 'MaskValues');
        
        visible = find(~strcmp(get_param(blk, 'MaskVisibilities'),'off'));
        
        params = params(visible);
        values = values(visible);
    end
end

%
%   localApply
%
function blockData = localApply(blockH)

blockData = ICBSupport('getblockData', blockH);

if ~isempty(blockData)
    PV = blockData.data.frame.getParameterValues;
    params = cell(PV(1));
    values = cell(PV(2));
    A = reshape({params{:}; values{:}}, length(params) * 2, 1);
    try
        set_param(blockH, A{:});
        ICBSupport('setblockdata', blockH, values);
        blockData.data.apply.setEnabled(false);
    catch
        % There was a problem with one of the parameters specified.
        error(lasterror);
    end
end

%
%   localPropertyPostSetCallback
%
function blockData = localPropertyPostSetCallback(varargin)

nargin
return

blockData = ICBSupport('getblockData', blockH);

if ~isempty(blockData)
     %blockData.data.frame.setParameter;
end

%
% localGetModel
%

function parent = localGetModel(blk)

parent = get_param(blk, 'Parent');
model = parent;

while (strcmp(lower(get_param(parent, 'Type')), 'block_diagram') ~= 1)
    model = parent;
    parent = get_param(model, 'Parent');
end
