function tempsreel2(signal)

%%%%%%%%%%%%%%%%%   -----Ondelettes-------   %%%%%%%%%%%%%%%%%

filtAn=symaux(8);

phi0 = filtAn;
j = 0;
h0 = reverse(phi0);                   %  cette ondelette nous donne le sign : eeg32
h1 = reverse(mirror(phi0));           % ... : residu
j = 1;
H0 = upSample(h0);
H1 = upSample(h1);
phi10 = waveletLo(phi0,H0);    % eeg16
phi11 = waveletHi(phi0,H1);    % beta = [16-32]Hz
j = 2;
H0 = upSample(H0);
H1 = upSample(H1);
phi20 = waveletLo(phi10,H0);   % eeg8L
phi21 = waveletHi(phi10,H1);   % eeg8H
phi22 = waveletHi(phi11,H1);   % [16-24]Hz
phi23 = waveletLo(phi11,H0);   % [24-32]Hz
j = 3;
H0 = upSample(H0);
H1 = upSample(H1);
phi30 = waveletLo(phi20,H0);   % [0-4]Hz
phi31 = waveletHi(phi20,H1);   % [4-8]Hz
phi32 = waveletHi(phi21,H1);   % alpha   = [8-12]Hz
phi33 = waveletLo(phi21,H0);   % sigma   = [12-16]Hz
phi34 = waveletLo(phi22,H0);   % [16-20]Hz
phi35 = waveletHi(phi22,H1);   % [20-24]Hz
phi36 = waveletHi(phi23,H1);   % [24-28]Hz
phi37 = waveletLo(phi23,H0);   % [28-32]Hz
j = 4;
H0 = upSample(H0);
H1 = upSample(H1);

phi40 = waveletLo(phi31,H0);   % alpha2   = [6-8]Hz
phi41 = waveletLo(phi32,H0);   % alpha1   = [8-10]Hz
phi42 = waveletHi(phi32,H1);   % alpha2   = [10-12]Hz

%%%%%%%%%%%%%%%%%%%%

[ech,canaux] = size(signal);

% Analyse

s1 = signal(:,13);
s1=resample(s1,128,64);
s2 = signal(:,15);
s2=resample(s2,128,64);

% Dcomposition
eeg32 = conv(s1,reverse(h0)); eeg32 = redconv(eeg32,h0);
eeg32b = conv(s2,reverse(h0)); eeg32b = redconv(eeg32b,h0);
alpha = conv(s1,reverse(phi40)); alpha = redconv(alpha,phi40);
alpha2 = conv(s2,reverse(phi40)); alpha2 = redconv(alpha2,phi40);
Ralpha = conv(s1,reverse(phi41)); Ralpha = redconv(Ralpha,phi41);
Ralpha2 = conv(s2,reverse(phi41)); Ralpha2 = redconv(Ralpha2,phi41);
eeg32var = var(eeg32);
eeg32bvar = var(eeg32b);

q=10;
Ik = length(eeg32);
for i=1:(Ik-q)
    NWPalpha (i) = var(alpha(i:i+q))/eeg32var;       %%%%%    Normalized Wavelet Power...
    NWPalpha2 (i) = var(alpha2(i:i+q))/eeg32bvar;
    R_NWPalpha (i) = var(Ralpha(i:i+q))/eeg32var;       %%%%%    Normalized Wavelet Power...
    R_NWPalpha2 (i) = var(Ralpha2(i:i+q))/eeg32bvar;
end;
Yas = (NWPalpha-NWPalpha2)./(NWPalpha+NWPalpha2);
YY=R_NWPalpha+R_NWPalpha2;

moyYY = median(YY);
moy = median(Yas);

if moyYY>0.3
    figure(1),
    plot(YY);title('YEUX FERMES !?!');
elseif moy<-0.1
    figure(1),
    plot(Yas);title('DROITE !?!');
elseif moy>0.05
    figure(1),
    plot(Yas);title('GAUCHE !?!');
else
    figure(1),
    plot(Yas);title('RIEN !?!');
end

