function tempsreel2(signal)

%%%%%%%%%%%%%%%%%   -----Ondelettes-------   %%%%%%%%%%%%%%%%%

filtAn=symaux(8);

phi0 = filtAn;
j = 0;
h0 = reverse(phi0);                   %  cette ondelette nous donne le sign : eeg32
h1 = reverse(mirror(phi0));           % ... : residu
j = 1;
H0 = upSample(h0);
H1 = upSample(h1);
phi10 = waveletLo(phi0,H0);    % eeg16
phi11 = waveletHi(phi0,H1);    % beta = [16-32]Hz
j = 2;
H0 = upSample(H0);
H1 = upSample(H1);
phi20 = waveletLo(phi10,H0);   % eeg8L
phi21 = waveletHi(phi10,H1);   % eeg8H
phi22 = waveletHi(phi11,H1);   % [16-24]Hz
phi23 = waveletLo(phi11,H0);   % [24-32]Hz
j = 3;
H0 = upSample(H0);
H1 = upSample(H1);
phi30 = waveletLo(phi20,H0);   % [0-4]Hz
phi31 = waveletHi(phi20,H1);   % [4-8]Hz
phi32 = waveletHi(phi21,H1);   % alpha   = [8-12]Hz
phi33 = waveletLo(phi21,H0);   % sigma   = [12-16]Hz
phi34 = waveletLo(phi22,H0);   % [16-20]Hz
phi35 = waveletHi(phi22,H1);   % [20-24]Hz
phi36 = waveletHi(phi23,H1);   % [24-28]Hz
phi37 = waveletLo(phi23,H0);   % [28-32]Hz
j = 4;
H0 = upSample(H0);
H1 = upSample(H1);

phi40 = waveletLo(phi31,H0);   % alpha2   = [6-8]Hz
phi41 = waveletLo(phi32,H0);   % alpha1   = [8-10]Hz
phi42 = waveletHi(phi32,H1);   % alpha2   = [10-12]Hz

%%%%%%%%%%%%%%%%%%%%

[ech,canaux] = size(signal);

% Analyse

s1 = signal(:,13);
s1 = resample(s1,128,64);
s2 = signal(:,15);
s2 = resample(s2,128,64);
s3 = signal(:,9);
s3 = resample(s3,128,64);
s4 = signal(:,10);
s4 = resample(s4,128,64);
s5 = signal(:,17);
s5 = resample(s5,128,64);
s6 = signal(:,18);
s6 = resample(s6,128,64);

% Dcomposition
    % Dcomposition    
    eeg32a = conv(s1,reverse(h0));    eeg32a_var = var(redconv(eeg32a,h0));  
    eeg32b = conv(s2,reverse(h0));    eeg32b_var = var(redconv(eeg32b,h0));  
    eeg32c = conv(s3,reverse(h0));    eeg32c_var = var(redconv(eeg32c,h0));  
    eeg32d = conv(s4,reverse(h0));    eeg32d_var = var(redconv(eeg32d,h0));  
    eeg32e = conv(s5,reverse(h0));    eeg32e_var = var(redconv(eeg32e,h0));  
    eeg32f = conv(s6,reverse(h0));    eeg32f_var = var(redconv(eeg32f,h0));  
    eeg32=redconv(eeg32a,h0);
    alpha1 = conv(s1,reverse(phi32)); alpha1 = redconv(alpha1,phi32); 
    alpha2 = conv(s2,reverse(phi32)); alpha2 = redconv(alpha2,phi32); 
    alpha3 = conv(s3,reverse(phi32)); alpha3 = redconv(alpha3,phi32); 
    alpha4 = conv(s4,reverse(phi32)); alpha4 = redconv(alpha4,phi32); 
    alpha5 = conv(s5,reverse(phi32)); alpha5 = redconv(alpha5,phi32); 
    alpha6 = conv(s6,reverse(phi32)); alpha6 = redconv(alpha6,phi32); 

    q=15;
    Ik = length(eeg32);
    for i=1:(Ik-q) 
        NWPalpha1(i) = var(alpha1(i:i+q))/eeg32a_var;       %%%%%    Normalized Wavelet Power...
        NWPalpha2(i) = var(alpha2(i:i+q))/eeg32b_var;
        NWPalpha3(i) = var(alpha3(i:i+q))/eeg32c_var;  
        NWPalpha4(i) = var(alpha4(i:i+q))/eeg32d_var;
        NWPalpha5(i) = var(alpha5(i:i+q))/eeg32e_var;  
        NWPalpha6(i) = var(alpha6(i:i+q))/eeg32f_var;
    end


YY=NWPalpha1+NWPalpha2+NWPalpha3+NWPalpha4+NWPalpha5+NWPalpha6;

moyYY = median(YY)


