function database_pca_processing

n_features=2;
n_users=2;
n_frames=2;
frame_offset=0;

training_database_path='C:\MATLAB6p5\work\training_database';
% user_name=['cda';'fcp';'ffc';'jos';'nrd';'plt';'shs';'ygs';'ynp'];

cd(training_database_path);
user_folders=dir;

user_folders(1)=[];
user_folders(1)=[];


[a,b] = pca_loading_sample_vectors2(training_database_path,n_frames,n_users,user_folders,frame_offset);

all_face_vectors = pca_loading_sample_vectors(training_database_path,n_frames,n_users,user_folders,frame_offset);


pca_mean_face_vector=mean(all_face_vectors,2);

removed_mean_all_face_vectors=removing_mean(all_face_vectors,pca_mean_face_vector);

[pca_eigenfaces,pca_eigenvalues]=eigenface_space_extractor(removed_mean_all_face_vectors,n_features);

data_with_mean=0;

pca_features=pca_features_extractor(pca_eigenfaces,removed_mean_all_face_vectors,data_with_mean,pca_mean_face_vector);

pca_users_features=reshape(pca_features,n_features,n_frames,n_users);

for user=1:n_users
    pca_mean_features(:,user)=mean(pca_users_features(:,:,user),2);
    pca_stdev_features(:,user)=std(pca_users_features(:,:,user),0,2);
end;

% pca_mean_features=mean(pca_features,2);
% pca_stdev_features=std(pca_features,0,2);

cd(training_database_path);
feature_file_name = sprintf('pca_features_feat%d_users%d_frames%d_frameoffset%d',n_features,n_users,n_frames,frame_offset);

save([training_database_path '\' feature_file_name],'pca_users_features','pca_mean_features','pca_stdev_features','pca_eigenfaces','pca_eigenvalues','pca_mean_face_vector');

cd 'C:\MATLAB6p5\work\';
