function [frr,far]=stat_eer

load pca_features_feat4_users4_frames10_frameoffset0.mat;
user_name=['cda';'fcp';'ffc';'jos';'nrd';'plt';'shs';'ygs';'ynp'];
test_database_path='C:\MATLAB6p5\work\test_database1';

n_test_users=4
n_training_users=4;

n_test_frames=2;

frame_offset=250;
method='mean';

n_points=10;

initial_theta=-(10^3)
final_theta=0;
increment_theta=(final_theta-initial_theta)/n_points;
theta=initial_theta;

for theta_index=1:n_points+1

    h_frr=0;
    c_frr=0;
    h_far=0;
    c_far=0;
    
    for test_user=1:n_test_users    
        for training_user=1:n_training_users
        
            user_face_vectors=pca_loading_sample_vectors(test_database_path,n_test_frames,1,user_name(test_user,:),frame_offset);
            
            accepted = pca_verification(user_face_vectors,training_user,theta,method,pca_eigenfaces,pca_mean_features,pca_mean_face_vector);
            
            if test_user==training_user
                h_frr=h_frr+accepted;
                c_frr=c_frr+1;
            else
                h_far=h_far+accepted;
                c_far=c_far+1;
            end;
            
        end;
    end;
    
    frr(theta_index)=1-(1/c_frr)*h_frr;
    far(theta_index)=(1/c_far)*h_far;
    theta=theta+increment_theta;
    
    theta_index
    theta
    
end;

theta=initial_theta:increment_theta:final_theta;
plot(theta,frr,'.-b');
hold on;
plot(theta,far,'.-r');
