function face_image_extraction(videofile,n_frames,saving_folder,saving_offset)

% Face extractor
% Extrats n_frames normalized gray-scale resized face images from a video
% file.

resize_method='bicubic';
extracted_face_dimension=[150 150];
extracted_face_border=[10 30];

plot_image=0;


warning off MATLAB:mir_warning_variable_used_as_function;

video = aviread(videofile,1:n_frames);

extracted_frames=1;
read_frames=1;

while (extracted_frames <= n_frames)
    
    if (read_frames <= n_frames)
        frame = frame2im(video(read_frames));
    else       
        clear video;
        clear frame;
        video = aviread(videofile,read_frames);
        frame = frame2im(video); 
    end;
    
    extracted_frames

    cd(saving_folder);
    
    prefilename = '%d';
    dataname  = sprintf(prefilename,extracted_frames+saving_offset);  
    filename = [dataname '.jpeg'];
    imwrite(frame,filename,'jpeg');
                
    % Moving to the face_detector MEX file directory
    cd 'C:\MATLAB6p5\work\face_detector';
            
    % Face detector: returns the coordinates of a square including
    % the face (or all 0 if not a face is not found)
            
    [p1x,p1y,p2x,p2y]=face_detector([saving_folder '\' filename]);
            
    % Only if a face is detected
    if ((p1x~=0)&(p1y~=0)&(p2x~=0)&(p2y~=0))|((p2x-p1x>20)&(p2y-p1y>20))
        detected_face_image = frame(p1y:p2y,p1x:p2x,:);
        resized_face_image = imresize(detected_face_image,extracted_face_dimension,resize_method);
        extracted_face_image=resized_face_image(1+extracted_face_border(1):extracted_face_dimension(1)-extracted_face_border(1),1+extracted_face_border(2):extracted_face_dimension(2)-extracted_face_border(2),:);
        
        gray_extracted_face_image = rgb2gray(extracted_face_image);
        
%         normalized_gray_extracted_face_vectors(:,extracted_frames) = double(gray_extracted_face_image(:))/255;
        normalized_gray_extracted_face_vectors = double(gray_extracted_face_image(:))/255;
        
        cd(saving_folder);
        
        save(dataname,'normalized_gray_extracted_face_vectors');
        
        extracted_frames=extracted_frames+1;
        
        if plot_image==1
            imshow(extracted_face_image);
        end;
       
        imwrite(gray_extracted_face_image,filename,'jpeg');
        
    end;
    
    read_frames=read_frames+1;
    
    cwd = pwd;
    cd('C:\MATLAB6p5\work\temp_garbage');
    pack
    cd(cwd)
    
end;

cd 'C:\MATLAB6p5\work';