function face_image_extraction3(videofile,n_frames,saving_folder)

% Face extractor
% Extrats n_frames normalized gray-scale resized face images from a video
% file.

resize_method='bicubic';
extracted_face_dimension=[150 150];
extracted_face_border=[10 30];

plot_image=0;

extracted_frames=1;

cd(videofile);
frame_name=dir('*.png');

n_frames_in_folder=size(frame_name,1);

if n_frames_in_folder<n_frames
    n_frames=n_frames_in_folder;
end;

for 251=1:n_frames

    filename = [videofile '\' frame_name(i).name];
    filenumber = sprintf('%d',extracted_frames);
    savingname = [saving_folder '\' filenumber];
    
    frame=imread(filename);
                
    % Moving to the face_detector MEX file directory
    cd 'C:\MATLAB6p5\work\face_detector';
            
    % Face detector: returns the coordinates of a square including
    % the face (or all 0 if not a face is not found)
            
    [p1x,p1y,p2x,p2y]=face_detector(filename);
            
    % Only if a face is detected
    if ((p1x~=0)&(p1y~=0)&(p2x~=0)&(p2y~=0))|((p2x-p1x>20)&(p2y-p1y>20))
        detected_face_image = frame(p1y:p2y,p1x:p2x,:);
        resized_face_image = imresize(detected_face_image,extracted_face_dimension,resize_method);
        extracted_face_image=resized_face_image(1+extracted_face_border(1):extracted_face_dimension(1)-extracted_face_border(1),1+extracted_face_border(2):extracted_face_dimension(2)-extracted_face_border(2),:);
        
        gray_extracted_face_image = rgb2gray(extracted_face_image);
        
        normalized_gray_extracted_face_vectors(:,extracted_frames) = double(gray_extracted_face_image(:))/255;
%         normalized_gray_extracted_face_vectors = double(gray_extracted_face_image(:))/255;
        
        cd(saving_folder);
        
        save(savingname,'normalized_gray_extracted_face_vectors');
        
        extracted_frames=extracted_frames+1
        
        if plot_image==1
            imshow(extracted_face_image);
        end;
       
        imwrite(gray_extracted_face_image,[savingname '.jpeg'],'jpeg');
        
    end;
    
    cwd = pwd;
    cd('C:\MATLAB6p5\work\temp_garbage');
    pack
    cd(cwd)
    
end;

% save(savingname,'normalized_gray_extracted_face_vectors');

cd 'C:\MATLAB6p5\work';