function [frr,far,theta]=stat_eer

load stat_features_feat15_users47_frames200_frameoffset0.mat;

test_database_path='C:\MATLAB6p5\work\training_database';

cd(test_database_path);
user_folders=dir;

user_folders(1)=[];
user_folders(1)=[];

n_test_users=47
n_training_users=4;

n_test_frames=1;

frame_offset=200;
method='mean';

n_points=1000;

initial_theta=-(10^4)
final_theta=0;
increment_theta=(final_theta-initial_theta)/n_points;
theta=initial_theta;

for theta_index=1:n_points+1

    h_frr=0;
    c_frr=0;
    h_far=0;
    c_far=0;
    
    for test_user=1:n_test_users    
        for training_user=1:n_training_users
        
            user_face_vectors=stat_loading_sample_vectors(test_database_path,n_test_frames,1,user_folders(test_user).name,frame_offset);
            
            accepted = stat_verification(user_face_vectors,training_user,theta,method,stat_eigenfaces,stat_mean_features);
            
            if test_user==training_user
                h_frr=h_frr+accepted;
                c_frr=c_frr+1;
            else
                h_far=h_far+accepted;
                c_far=c_far+1;
            end;
            
        end;
    end;
    
    frr(theta_index)=1-(1/c_frr)*h_frr;
    far(theta_index)=(1/c_far)*h_far;
    theta=theta+increment_theta;
    
    theta_index
    theta
    
end;

theta=initial_theta:increment_theta:final_theta;
plot(theta,frr,'.-b');
hold on;
plot(theta,far,'.-r');
