% creates a window with menus and interface to analyse/modify F0, TL, HNR
% and NRJ

clear all;

% global handlers, variables ..
global zoomChangeHan panChangeHan infoHan speedHan fpsEditHan currentPosFile posFileList tempMovieFile;

sigFilesDir = 'signature_data'; % directory containing signatures data
posFileDir = 'testFiles'; % any existing temporary directory to contain intermediate files
tempMovieFile = 'testFiles\tempMovieFile.mat'; % temporary file

listDir = dir(sigFilesDir);
for ii = 3 : length(listDir)
    tempName = listDir(ii).name;
    namesList{ii-2} = strrep(tempName, '.dat', '');
    inFile = [sigFilesDir '/' namesList{ii-2} '.dat'];
    posFileList{ii-2} = [posFileDir '\posFile_' namesList{ii-2} '.mat'];
	fprintf('inFile: %s\n',inFile);
    makeDataForMovie(inFile,posFileList{ii-2});
end

%namesList = {'YannisS.'; 'Felipe'; 'Pedro'; 'Federico'; 'Thanasios'; 'YannisP.'; 'Francois'; 'Stephanie'};

%%%%%%%%%%%%%%%%%%%%%%% MAIN FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

mainFigHan = figure('Name','Learning Forgery Signatures','MenuBar','none','Units','normalized','Position',[0 .03 1 .92]);

%%%%%%%%%%%%%%%%%%%%%%% TOP MENUS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% non-used handler, just to be enable use of "Alt" for other uses (e.g. for zooming out)
helloHan = uimenu('Label','Hello','Position',1);
namesHan = uimenu('Label','Signers','Position',2);

for ii = 1:length(namesList)
    uimenu('Label',namesList{ii},'Parent',namesHan, 'Tag', num2str(ii), ...
        'Callback',['global posFileList currentPosFile; jj = str2num(get(gcbo,''Tag'')); currentPosFile = posFileList{jj}; makePicture;' ...
        'set(makeMovieHan,''Enable'',''on''); set(playMovieHan,''Enable'',''on'')']);
end

%%%%%%%%%%%%%%%%%%% CONTROLS - zoom, pan ; info window %%%%%%%%%%%%%%%%%%%%

zoomChangeHan = uicontrol('Style','togglebutton','String','ZOOM','Units','characters',...
    'Position',[10 48 10 1.5],'Enable','off','Callback','zoomChange;');
panChangeHan = uicontrol('Style','togglebutton','String','PAN','Units','characters',...
    'Position',[10 45 10 1.5],'Enable','off','Callback','panChange;');

% static + editable texts to control several parameters : fps,..
fpsEditHan = uicontrol('Style','edit','Units','characters','Position',[155 2.5 20 1.5],...
    'String','24');
fpsStaticHan = uicontrol('Style','text','Units','characters','Position',[175 2.5 20 1.5],...
    'String','Frames per second');
speedHan = uicontrol('Style','slider','Min',0.1,'Max',3,'Value',1,'SliderStep',[0.01 0.1],...
    'Units','characters','Position',[50 2 100 2],...
    'Callback','global speedValueHan; set(speedValueHan,''String'',get(speedHan,''Value''));');
speedValueHan = uicontrol('Style','text','Units','characters','Position',[38 2.1 10 2],...
    'String','1');
makeMovieHan = uicontrol('Style','Pushbutton','Units','characters','Position',[5 30 15 10],...
    'String','MAKE MOVIE','Callback','makeMovie','Enable','off');
playMovieHan = uicontrol('Style','Pushbutton','Units','characters','Position',[5 15 15 10],...
    'String','PLAY MOVIE','Callback','playMovie','Enable','off');
