function movieMat = makeDataForMovie(inFile,posFile)

% make matrix by reading file ; file has to be comma-separated values
data = csvread(inFile);

% loop - filling positions vectors (X and Y)
posX(1) = data(1,1);
posY(1) = -data(1,2);
indexTime = 1; % [ms]
minusOneFlag = 0;
for ii = 2:size(data,1)
    if(minusOneFlag > 0)
        minusOneFlag = minusOneFlag - 1;
    else
        curTime = data(ii,4);
        posX(curTime) = data(ii,1);
        posY(curTime) = -data(ii,2);
        curTouch = data(ii,3);
        % filling vectors posX and posY, ms by ms; then we can take any value we want to build the movie
        if (curTouch ~= -1)
            if(posX(curTime) == posX(indexTime))
                posX(indexTime:curTime) = posX(indexTime);
            else
                posX(indexTime:curTime) = ...
                    posX(indexTime) : (posX(curTime)-posX(indexTime))/(curTime-indexTime) : posX(curTime);
            end
            if(posY(curTime) == posY(indexTime))
                posY(indexTime:curTime) = posY(indexTime);
            else
                posY(indexTime:curTime) = ...
                    posY(indexTime) : (posY(curTime)-posY(indexTime))/(curTime-indexTime) : posY(curTime);
            end
        else
            curTime = data(ii+1,4);
            posX(indexTime+1:curTime-1) = -1;
            posY(indexTime+1:curTime-1) = -1;
            posX(curTime) = data(ii+1,1);
            posY(curTime) = -data(ii+1,2);
            minusOneFlag = 1;
            jj = ii+1;
            while(data(jj,3) == -1)
                curTime = data(jj+1,4);
                posX(indexTime+1:curTime-1) = -1;
                posY(indexTime+1:curTime-1) = -1;
                minusOneFlag = minusOneFlag+1;
                jj = jj+1;
            end
            curTime = data(jj+1,4);
            posX(indexTime+1:curTime-1) = -1;
            posY(indexTime+1:curTime-1) = -1;
            posX(curTime) = data(jj+1,1);
            posY(curTime) = -data(jj+1,2);
        end
        indexTime = curTime;
    end
end
save(posFile,'posX','posY')
