global speedHan fpsEditHan currentPosFile tempMovieFile;
clear tempMovieMat

load(currentPosFile);
fps = str2double(get(fpsEditHan,'String'));
speedRate = str2double(get(speedValueHan,'String'));

% loop - building the movie matrix according to the desired speed rate
%tempFig = figure('Color','w','Visible','off');
cla;
hold on
axis([0.9*min(posX) 1.1*max(posX) 1.1*min(posY) 0.9*max(posY)]); % !! posy < 0
set(gca,'Visible','off');
set(gcf,'Color','w');
numFrames = floor(length(posX)/1000*fps/speedRate); % total number of frames = totalTime[s] * fps / speedRate
begIndex = 1;
for indexMat = 1:numFrames
    matCurTime = round(indexMat/fps*1000*speedRate); % [ms]
    if(posX(matCurTime) == -1)
        begIndex = round((indexMat+1)/fps*1000*speedRate);        
        tempMovieMat(indexMat) = getframe;
    else
        curXline = posX(begIndex:matCurTime);
        curYline = posY(begIndex:matCurTime);
        plot(curXline,curYline,'k');
        tempMovieMat(indexMat) = getframe;
    end
end
hold off

save(tempMovieFile,'tempMovieMat')
