function CreateWorld()
%
% CreateWorld()
%
% This function creates the world GMM model
%

% Check first if there is a world model. If yes, then delete it
config;
fprintf('\n**** Creating World Model ****\n');
wft = dir(WORLD_FEAT_FILE);
if(length(wft)~=0)
	delete(WORLD_FEAT_FILE);
end

% get the features from users
lft = dir('*.ft');
N = length(lft);

fpout = fopen(WORLD_FEAT_FILE,'wb');
fwrite(fpout,[0,0],'ulong');  % keep the first two places for dim and time

NofObs = 0;  % total number of observations

for i=1:N
   
  fp = fopen(lft(i).name, 'rb');
  ul = fread(fp,2,'ulong');
  D = ul(1); % this should not changed from file to file
  M = ul(2); % number of observations in the current file
  NofObs = NofObs+M;

  % get the observations
  o = fread(fp,'double');

  % write data
  fwrite(fpout, o, 'double');

  fclose(fp);
end

% write the first ulong numbers
fseek(fpout,0,'bof');
fwrite(fpout,[D, NofObs], 'ulong');

fclose(fpout);
