function [eer,theer]=EER(theta, Genf, Imf, plfg)

%
% [eer,theer]=EER(theta, Genf, Imf, plfg)
%
% It computes the Equal Error Rate and plots the DET-curve if plfg
% is provided and it is equal to 1
% Genf : filename of scores from the genuine signals
% Imf  : filename of scores from the forgery (skilled or random) signals 
%
config;


Lth = length(theta);

a = zeros(Lth,1); % allocation for the False Rejection Rate (FRR)
b = zeros(Lth,1); % allocation for the False Acceptance Rate (FAR)

% get genuine scores
fp = fopen(Genf,'rb');
Gn = fread(fp,'float');
fclose(fp);
% remove problems : nan inf etc  NORMALLY we should not have these problems.
% CHECK Learning....
in = find(isfinite(Gn)==1);
Gn=Gn(in);
Lg = length(Gn);

% get impstor score
fp = fopen(Imf,'rb');
fprintf('opening %s\n',IMPOSTOR_FILE);
disp(fp);
Im = fread(fp,'float');
fclose(fp);
% remove problems : nan inf etc
in = find(isfinite(Im)==1);
Im=Im(in);
Li = length(Im);

for th=1:Lth
  L1 = length(find(Gn>theta(th)));
  L2 = length(find(Im>theta(th)));

  a(th) = 1-L1/Lg;
  b(th) = L2/Li;
end

% find the eer
[vl,im]=min(abs(a-b));
eer =  (a(im)+b(im))/2;
theer = theta(im);    % \theta_{err}

if(nargin<4)
  plfg=0;
end

if(plfg==1)
    subplot(121);
    plot(theta,a);hold on;plot(theta,b,'g');hold off
    xlabel('theta');
    legend('FRR','FAR');
    % Plot DET
    subplot(122);
    plot(a,b);
    st1 = sprintf('EER: %.2f', eer);
    title(st1);
    xlabel('False Reject Rate');
    ylabel('False Acceptance Rate');
end
