function [P wLH]= getLHs(feat, model, wmodel) 
% function [P wLH]= getLHs(X, modality, drct)
% X: Matrix of feature vectors
% modality: voice / signature ... (string)
% drct: directory of the models
    
a = model.priors;
mX = (model.centres)';
cX = model.covars;
M = length(a);

LH = 0;      % likelihood
for t = 1:T
	x = feat(t,:);
	p = p_gmm(x', M, a, mX, cX);
    LH = LH + log10(p+realmin);
end
LH = (LH/T);

a = wmodel.priors;
mX = (wmodel.centres)';
cX = wmodel.covars;
M = length(a);

wLH = 0;      % likelihood
for t = 1:T
    x = feat(t,:);
    p = p_gmm(x', M, a, mX, cX);
    wLH = wLH + log10(p+realmin);
end
wLH = (wLH/T);

LH = LH - wLH;




