function getfeat(usr,n1,n2);
% n1: Begining of adquisition of signatures
% n2: end    "                      "
%
% getfeat(usr,n1,n2);
%
%
% ex: getfeat(1,1,15);
%

%dr = readdir;
%users = readusr;
%disp(dr);
%disp(users);
config

Outf1 = [users(usr,:) '.ft'];  % for feature information
fp1 = fopen(Outf1, 'wb');

Tt = zeros(n2-n1+1,1);

lsf = dir([dr users(usr,:) '/real-*.dat']);
disp('getfeat()');
for i=n1:n2

  % make filename
  fl = lsf(i).name;
  disp(fl);

  % get features according Jonas' paper
  [o, Tt(i-n1+1)]=jonaspar([dr users(usr,:) '/' fl]);
  %[o, Tt(i-n1+1)]=jonaspar([fl]);

  [D,M]=size(o);

  fwrite(fp1,reshape(o,1,D*M),'float');

end
fclose(fp1);

% mean and standard deviation of Time
mTt = mean(Tt);
sTt = std(Tt);

% Perform normalizations
fp1 = fopen(Outf1, 'rb');
o = fread(fp1,'float');
fclose(fp1);
o = reshape(o,D,length(o)/D);

mu = zeros(D,1);
s  = zeros(D,1);
for i=1:D
  mu(i) = mean(o(i,:));
  s(i)  = std(o(i,:));
  o(i,:) = o(i,:)/s(i);  % (o(i,:)-mu(i))/s(i);
end

% save normalized data according to the VQ datafile
fp1 = fopen(Outf1, 'wb');
[D,M] = size(o);
fwrite(fp1,[D,M],'ulong');
fwrite(fp1,reshape(o,1,D*M),'double');
fclose(fp1);


% save global features like mean and standard deviations
Outf1 = [users(usr,:) '.gf']; % for feature information
fp1 = fopen(Outf1, 'wb');
fwrite(fp1,[mu;mTt;s;sTt],'float');  % do reshape(a,6,2) to get back your vector
fclose(fp1);



  

