function getgenuinescore(L1,L2)

%
% getgenuinescore(L1,L2)
%
% it computes the likelihoods from genuine signals
% results are saved for later use (e.g., in the EER.m)
% L1: starting index of signals to use
% L2: last index of signals to use
%


% open a file to save the genuine scores
config;
fpg = fopen(GENUINE_FILE,'wb');

[Nu,d]=size(users);

for u=1:Nu
  fl= locatef(u,[L1 L2]);
  [Nf,d] =  size(fl);
  res = zeros(Nf,1);

  for f=1:Nf
    res(f) = mlike(fl(1,:),users(u,:), WORLD_MODEL_FILE);
  end

  % save data
  fwrite(fpg,res,'float');

end

fclose(fpg);
