function identify(unknown, withsign)
%
%  identify(unknown, withsign)
%
% example: identify('aab',15)
%

%dr = readdir;
%users = readusr;
config;
Nu = length(users);

lsf = dir([dr unknown '/*.dat']);
fl = [dr unknown '/' lsf(withsign).name];
[o, Tt]=jonaspar(fl);
[D,M]= size(o);

Lk = zeros(Nu,1);

oc = o;

for n=1:Nu
 
  % read the global features for the target USER
  canbe = users(n,:);
  [mu,s]=readgf(canbe,D);


  % normalize vectors
  for i=1:D
    oc(i,:) = o(i,:)/s(i);  % (o(i,:)-mu(i))/s(i);
  end

  % save normalized data according to the VQ datafile
  fp1 = fopen('chk', 'wb');
  fwrite(fp1,[D,M],'ulong');
  fwrite(fp1,reshape(oc,1,D*M),'double');
  fclose(fp1);

  % get average likelihood
  s_log = ['!./logL -D chk -M ' canbe '.em >res'];
  eval(s_log);
  Lk(n) = load('res');

  % get average likelihood reagrding the world model
  s_log = ['!./logL -D chk -M World.em >resW'];
  eval(s_log);
  resW = load('resW');

  Lk(n) = Lk(n)-resW;

  
end


  [vl,in]=max(Lk);
  idn = users(in,:);

  disp(['Probably, you are the user with the code: ' idn]);
 
