function [o, Tt]=jonaspar(fl)

%
% [o, Tt]=jonaspar(fl,n1,n2)
%
% It computes the parameters of a signature as there are described
% in Jonas Richiarrdi et al. WBMA'03, from file 'fl'
% 
%
% INPUT: 
%       fl   : file name (ex: 'USER1');
% OUTPUT:
%       o : observation vector (x,y,p,theta,v)
%       Tt: total time in seconds to sign 
%

% Yannis Stylianou, 2005, eNTERFACE 2005 

% Tests on Our DB
config;

 % get features
 %disp('jonaspar()');
 disp(fl);
 fp = load(fl);
 nomone = find(fp(:,3)~=-1);
 fp = fp(nomone,:);
 N = length(fp);  % number of observations
 x =fp(:,1);
  x = x -x(1); % subtract the initial value for all the rest
 y = fp(:,2);
  y = y - y(1);  % subtract the initial value for all the rest
 p = fp(:,3);    % pressure
 dx = [0;diff(x)];
 dy = [0;diff(y)];
 theta = atan2(dy,dx);
 v = sqrt(dx.^2+dy.^2);

 % observation vector
 o = [x y p theta v]';

 % total time to sign a signture in seconds 
 Tt = (fp(N,4)-fp(1,4))/1000;


    
   

 
