function fl=locatef(u,n)

%
% fl=locatef(u, n)
% 
% It locates the file(s) of user u. If n it is just a number 
% then it is supposed that we want exactly that file. If n is a vector 2x1,
% then we suppose that want the list of all files from number n(1) to n(2)
% 
%
config
str = [dr users(u,:)];
lsf = dir([str '/real-*.dat']);

if(length(n)==1)
  Sn=n;
  Tn = n;
else
  Sn=n(1);
  Tn = n(2);
end 

v= [str '/'];
fl=[repmat(v,Tn-Sn+1,1) char({lsf(Sn:Tn).name})];
