function ll = mlike(fl,l,w)
%
%
% get the likelihood that model of user, l, produced the signal, fl,
% having as reference - background - the world model, w.
%

[o, Tt]=jonaspar(fl);
[D,M]= size(o);


% read the global features for user, l
  [mu,s]=readgf(l,D);

% normalize vectors
for i=1:D
  o(i,:) = o(i,:)/s(i);  % (o(i,:)-mu(i))/s(i);
end


% save normalized data according to the VQ datafile
fp1 = fopen('chk', 'wb');
[D,M] = size(o);
fwrite(fp1,[D,M],'ulong');
fwrite(fp1,reshape(o,1,D*M),'double');
fclose(fp1);

% get average likelihood
s_log = ['!./logL -D chk -M ' l '.em >res'];
eval(s_log);
res = load('res');

% get average likelihood reagrding the world model
s_log = ['!./logL -D chk -M ' w ' >resW'];
eval(s_log);
resW = load('resW');

% likelihood
ll = res-resW;

