/*
 * Copyright (c) 1996-2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

/*
 * Lots of modifications made while eNTERFACE 2005.
 */

import javax.media.*;
import javax.media.protocol.*;
import javax.media.control.*;
import javax.media.format.*;
import javax.swing.JFrame;

import java.awt.*;
import com.sun.media.controls.VFlowLayout; // Lays components one below the other
import java.awt.event.*;

public class JVidCap extends JFrame implements ActionListener {
	
	// GUI components
	
	Panel jPanel1 = new Panel();
	VFlowLayout verticalFlowLayout1 = new VFlowLayout();
	Label jLabel1 = new Label();
	Panel jPanel2 = new Panel();
	Panel jPanel3 = new Panel();
	Button buttonStart = new Button();
	Button buttonExit = new Button();
	Button buttonEnd = new Button();
	Panel panel1 = new Panel();
	GridLayout gridLayout1 = new GridLayout();
	GridLayout gridLayout2 = new GridLayout();
	
	// JMF objects
	Processor processor = null;
	DataSink datasink = null;
	Component monitor = null;
	DataSource datasource = null;
	
	Lunch mainApp;
	
	public JVidCap(Lunch ma) {
		mainApp = ma;
		setTitle("Face");
		jPanel1.setLayout(verticalFlowLayout1);
		jPanel2.setLayout(gridLayout2);
		jPanel3.setLayout(gridLayout1);
		buttonStart.setLabel("Start");
		buttonExit.setLabel("Exit");
		buttonExit.addActionListener(this);
		buttonEnd.setEnabled(false);
		buttonEnd.setLabel("End");
		add(jPanel1, BorderLayout.WEST);
		jPanel1.add(jLabel1);
		jPanel1.add(jPanel3);
		jPanel1.add(jPanel2);
		jPanel1.add(buttonStart);
		jPanel1.add(buttonEnd);
		jPanel1.add(buttonExit);
		add(panel1, BorderLayout.CENTER);
		buttonStart.addActionListener(this);
		buttonEnd.addActionListener(this);
		startMonitoring();
	}
	
	private void startMonitoring() {
		// Close the previous processor, which in turn closes the capture device
		if (processor != null) {
			processor.stop();
			processor.close();
		}
		// Remove the previous monitor
		if (monitor != null) {
			panel1.remove(monitor);
			monitor = null;
		}
		
		AudioFormat af = null;
		VideoFormat vf = null;
		
		int samplingRate = 44100;//Integer.parseInt(comboSampling.getSelectedItem());
		int samplingSize = 16;//radio8bit.getState() ? 8:16;
		int channels = 1;//radioMono.getState()? 1:2;
		af = new AudioFormat(AudioFormat.LINEAR, samplingRate, samplingSize,
				channels);
		String encoding = "RGB";//comboEncoding.getSelectedItem();
		Dimension size = new Dimension(320, 240);//new Dimension(sizeX, sizeY);
		
		vf = new VideoFormat(encoding, size, Format.NOT_SPECIFIED, null, 15f);
		
		// Use CaptureUtil to create a monitored capture datasource
		datasource = CaptureUtil.getCaptureDS(vf, af);

		if (datasource != null) {
			// Set the preferred content type for the Processor's output
			FileTypeDescriptor ftd = new FileTypeDescriptor("video.x_msvideo");
			Format [] formats = null;
			
			if (af != null && vf != null) {
				formats = new Format[] { new AudioFormat(null),
						new VideoFormat(null) };
			}
			
			if (af == null)
				formats = new Format[] {new VideoFormat(null)};
			
			ProcessorModel pm = new ProcessorModel(datasource, formats, ftd);
			try {
				processor = Manager.createRealizedProcessor(pm);
			} catch (Exception me) {
				System.err.println(me);
				// Make sure the capture devices are released
				datasource.disconnect();
				return;
			}
			
			// Get the monitor control:
			// Since there are more than one MonitorControl objects
			// exported by the DataSource, we get the specific one
			// that is also the MonitorStream object.
			MonitorControl mc = (MonitorControl)datasource.getControl("MonitorStream");
			if (mc != null) {
				monitor = mc.getControlComponent();
				panel1.add(monitor);
				// Make sure the monitor is enabled
				mc.setEnabled(true);
				pack();
			}
		}
	}
	
	private void startCapture() {
		enableComponents(false);
		buttonStart.setLabel("Pause");
		buttonEnd.setEnabled(true);
		
		// Get the processor's output, create a DataSink and connect the two.
		DataSource outputDS = processor.getDataOutput();
		try {
			MediaLocator ml = new MediaLocator("file:test.avi");
			datasink = Manager.createDataSink(outputDS, ml);
			datasink.open();
			datasink.start();
		} catch (Exception e) { System.err.println(e); }
		processor.start();
		System.out.println("Started saving...");
	}
	
	private void pauseCapture() {
		processor.stop();
		buttonStart.setLabel("Resume");
	}
	
	private void resumeCapture() {
		processor.start();
		buttonStart.setLabel("Pause");
	}
	
	private void stopCapture() {
		Image img = monitor.createVolatileImage(320, 240);

		//mainApp.newFrame(monitor.createVolatileImage(320, 240));

		// Stop the capture and the file writer (DataSink)
		processor.stop();
		processor.close();
		datasink.close();
		processor = null;
		buttonEnd.setEnabled(false);
		// Restart monitoring
		startMonitoring();
		buttonStart.setLabel("Start");
		enableComponents(true);
		System.out.println("Done saving.");
	}
	
	
	private void enableComponents(boolean state) {
		buttonExit.setEnabled(state);
	}	
	
	void exit() {
		if (processor != null) processor.close();
		dispose();
//		System.exit(0);
	}
		
	public void actionPerformed(ActionEvent ae) {
		String action = ae.getActionCommand();
		if (action.equals("Start")) startCapture();
		else if (action.equals("Pause")) pauseCapture();
		else if (action.equals("Resume")) resumeCapture();
		else if (action.equals("End")) stopCapture();
		else if (action.equals("Exit")) exit();
	}

//	public static void main(String[] args) {
//		JVidCap JVidCap1 = new JVidCap();
//		JVidCap1.setVisible(true);
//		JVidCap1.pack();
//	}
	
}
