import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

import jwintab.Jwintab;

import org.amsl.audio.AudioRecorder;
import org.amsl.gui.HWMainWindow;
import org.amsl.hw.HWSignal;
import org.amsl.hw.HWSignalConsumer;

import se.datadosen.component.RiverLayout;

/*
 * Created on 02.08.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class Lunch extends JFrame implements HWSignalConsumer {
	
	private JTextField user;
	private JCheckBox  lunch;
	private JCheckBox  dinner;
	private JButton    photo;
	private JButton    voice;
	private JButton    signature;
	private JButton    submit;
	
	private HWSignal   signal;
	
	private JDialog       recordDialog;
	private JButton       record;
	private JLabel        recordTimer;
	private AudioRecorder recorder = null;
	
	private JDialog       videoDialog;
	private boolean       capturing = false;

	public static void main(String[] args) {
		Jwintab.open();
		new Lunch();
	}
	
	public Lunch() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setResizable(false);

		Container c = getContentPane();
		c.setLayout(new RiverLayout());

		c.add("center", new JLabel("Lunch Reservation"));

		c.add("br left", new JLabel("Please enter your name"));
		c.add("tab", user = new JTextField(20));
		user.addKeyListener(new KeyListener() {
			public void keyTyped(KeyEvent e) {}
			public void keyPressed(KeyEvent e) {}
			public void keyReleased(KeyEvent e) { getUser(); }
		});

		c.add("br left", new JLabel("Wanna have some lunch?"));
		c.add("tab", lunch = new JCheckBox());
		lunch.setEnabled(false);

		c.add("br left", new JLabel("Wanna have dinner?"));
		c.add("tab", dinner = new JCheckBox());
		dinner.setEnabled(false);
		
		c.add("br left", new JLabel("Photo"));
		c.add("tab", photo = new JButton(new ImageIcon("images/no_photo.png")));
		photo.setBorder(null);
		photo.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { getPhoto(); } });
		photo.setEnabled(false);

		c.add("br left", new JLabel("Voice"));
		c.add("tab", voice = new JButton(new ImageIcon("images/no_voice.png")));
		voice.setBorder(null);
		voice.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { getVoice(); } });
		voice.setEnabled(false);
		
		c.add("br left", new JLabel("Signature"));
		c.add("tab", signature = new JButton(new ImageIcon("images/no_signature.png")));
		signature.setBorder(null);
		signature.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { getSignature(); } });
		signature.setEnabled(false);
		
		c.add("br center", submit = new JButton("submit"));
		submit.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { submit(); } });
		submit.setEnabled(false);

		pack();
		setVisible(true);

	}
	
	private void getUser() {
		if (user.getText().trim().length() > 0) {
			lunch.setEnabled(true);
			dinner.setEnabled(true);
			photo.setEnabled(true);
			voice.setEnabled(true);
			signature.setEnabled(true);
			submit.setEnabled(true);
		} else {
			lunch.setEnabled(false);
			dinner.setEnabled(false);
			photo.setEnabled(false);
			voice.setEnabled(false);
			signature.setEnabled(false);
			submit.setEnabled(false);
		}
	}

	private void getVoice() {
		recordDialog = new JDialog(this, "Voice");
		recordDialog.setLayout(new RiverLayout());
		record = new JButton("Start recording ...");
		record.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { record(); } });
		recordDialog.add("center", record);
		recordDialog.pack();
		recordDialog.setVisible(true);
	}
	
	private void getPhoto() {
		JVidCap JVidCap1 = new JVidCap(this);
		JVidCap1.setVisible(true);
		JVidCap1.pack();
	}
	
	private void getSignature() {
		HWMainWindow win = new HWMainWindow(-1, -1);
		signal = win.signal;
		signal.addConsumer(this);
	}
	
	public void newFrame(Image img) {
		photo.setIcon(new ImageIcon(img));
	}
	
	public void newSignature() {
		BufferedImage image = new BufferedImage(200, 120, BufferedImage.TYPE_3BYTE_BGR);
		for (int x = 0; x < 200; ++x)
			for (int y = 0; y < 120; ++y)
				image.setRGB(x, y, 0xffffff);
		int[] bbox = signal.getBoundingBox();
		Vector s = signal.getSignalVector();
		for (int i = 0; i < s.size(); ++i) {
			int sample[] = (int[]) s.elementAt(i);
			if (sample[0] < 0) continue;
			int x = (sample[0] - bbox[0]) * 198 / (bbox[2] - bbox[0]);
			int y = (sample[1] - bbox[1]) * 118 / (bbox[3] - bbox[1]);
			image.setRGB(x, y, 0x000000);
			image.setRGB(x+1, y, 0x000000);
			image.setRGB(x, y+1, 0x000000);
			image.setRGB(x+1, y+1, 0x000000);
		}

		signature.setIcon(new ImageIcon(image));
	}

	private void record() {
		if (recorder == null) {
			try { recorder = new AudioRecorder("test.wav"); }
			catch (Throwable e) { System.err.println(e); }
			recorder.start();
			record.setText("Stop recording...");
		} else {
			recorder.stopRecording();
			recordDialog.dispose();
			voice.setIcon(new ImageIcon("images/voice.png"));
		}
	}
	
	private void submit() {
		boolean lunch  = this.lunch.isSelected();
		boolean dinner = this.dinner.isSelected();
		String  user   = this.user.getText();
		System.out.println(user + (lunch ? ",lunch" : ",nolunch") + (dinner ? ",dinner" : ",nodinner"));
	}

	public void update() {}

	public void reload() {
		newSignature();
	}

	public void setSignal(HWSignal s) {
		signal = s;
	}

}
