package org.amsl.audio;

import java.io.*;
import javax.sound.sampled.*;

public class AudioPlayer {
	private static final int EXTERNAL_BUFFER_SIZE = 128000;

	public AudioPlayer(String file) throws Throwable {
		File soundFile = new File(file);
		AudioInputStream audioInputStream = null;

		audioInputStream = AudioSystem.getAudioInputStream(soundFile);

		AudioFormat audioFormat = audioInputStream.getFormat();
		SourceDataLine line = null;
		DataLine.Info info = new DataLine.Info(SourceDataLine.class,
				audioFormat);
		line = (SourceDataLine) AudioSystem.getLine(info);
		line.open(audioFormat);
		line.start();

		int nBytesRead = 0;
		byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
		while (nBytesRead != -1) {
			nBytesRead = audioInputStream.read(abData, 0, abData.length);
			if (nBytesRead >= 0) {
				int nBytesWritten = line.write(abData, 0, nBytesRead);
			}
		}

		line.drain();
		line.close();
	}

}