package org.amsl.audio;

import java.io.*;
import javax.sound.sampled.*;

public class AudioRecorder extends Thread {

	private TargetDataLine   line;
	private AudioInputStream audioInputStream;
	private File             outputFile;

	public AudioRecorder(String file) throws Throwable {
		AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
				22050.0F, 16, 2, 4, 22050.0F, false);
		DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
		line = (TargetDataLine) AudioSystem.getLine(info);
		line.open(format);
		outputFile = new File(file);
		audioInputStream = new AudioInputStream(line);
	}

	public void start() {
		line.start();
		super.start();
	}

	public void stopRecording() {
		line.stop();
		line.close();
	}

	public void run() {
		try { AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, outputFile); }
		catch (IOException e) { e.printStackTrace(); }
	}

}
