/*
 * Created on 07.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.amsl.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileWriter;
import java.util.Vector;
//import java.io.FileWriter;
//import java.io.IOException;
//import java.util.Vector;
import javax.swing.*;
import org.amsl.hw.*;

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HWMainWindow extends JDialog implements HWSignalConsumer, ItemListener {

	HWSignalSource   source      = null;
	public HWSignal         signal      = null;
	int              signalIndex = 0;
	int 		     timeZero    = -1; 
	boolean          isInfinite  = true;
	HWXYSignalViewer xyViewer    = null;
	HWStatusBar      statusBar   = null;
	JCheckBox        stdout      = null;
	JButton          save        = null;
	JButton          device		 = null;
	ImageIcon[]      deviceIcons = null;
	ImageIcon[]      stdoutIcons = null;
	int 			 deviceId    = 0;
	
	public HWMainWindow(int x, int y) {
//		super("Handwriting recording tool");

		signal = new HWSignal();

		try {
			//source = new HWTabletPCSignal(signal, x, y);
			source = new HWMouseSignal(signal);
		} catch (Throwable e) {
			e.printStackTrace();
			System.err.println(e);
			System.exit(-1);
		}
		xyViewer = new HWXYSignalViewer(signal);
		
		// GUI
		setPreferredSize(new Dimension(1024, 768));
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

		add(xyViewer);
		add(createBottomBox());
		pack();

		try {
			Thread.sleep(3000);
		} catch (Throwable e) {}

		setVisible(true);
		xyViewer.setInteractive(true);
		signal.addConsumer(this);
		source.start();
		source.setTimeout(200000);
	}
	
	private JPanel createBottomBox() {
		JToolBar toolBar = new JToolBar();
		toolBar.setFloatable(false);

		save = new JButton(new ImageIcon("images/save.gif"));

		JButton clear  = new JButton(new ImageIcon("images/trash.png"));
//		JButton close  = new JButton(new ImageIcon("images/close.png"));

//		stdout.addChangeListener(new ChangeListener() { public void stateChanged(ChangeEvent e) { actionStdout(e.getSource()); } });		
//		device.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { actionDevice(); } });
		save.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { actionSaveSig(); } });
		clear.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { actionClear(); } });
//		close.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { dispose(); } });

//		stdout.setToolTipText("don't write to stdout");
//		device.setToolTipText("change tablet orientation");
		save.setToolTipText("save to DB");
		clear.setToolTipText("clear canvas");
//		close.setToolTipText("close application");

		//toolBar.add(new JButton(new ImageIcon("images/mouse.png")));
//		toolBar.add(device);
		toolBar.add(save);
		toolBar.add(clear);
//		toolBar.add(stdout);
//		toolBar.add(close);

		statusBar = new HWStatusBar(signal); // global variable

		JPanel bottom = new JPanel();
		bottom.setLayout(new BorderLayout());
		bottom.setMaximumSize(new Dimension(2000,30));
		bottom.add(statusBar, BorderLayout.CENTER);
		bottom.add(toolBar, BorderLayout.EAST);
		return bottom;
	}
	
	public void setSignal(HWSignal s) {
		signal = s;
		statusBar.setSignal(s);
		xyViewer.setSignal(s);
		signal.notifyConsumers(true);
		xyViewer.setInteractive(true);
		xyViewer.reload();
	}

	private void actionStdout(Object s) {
		boolean c = ((JCheckBox) s).isSelected();
		if (c != isInfinite) {
			isInfinite = c;
			if (isInfinite) {
				save.setEnabled(false);
				stdout.setIcon(stdoutIcons[0]);
				stdout.setToolTipText("don't write to stdout");
			} else {
				save.setEnabled(true);
				stdout.setIcon(stdoutIcons[1]);
				stdout.setToolTipText("write to stdout");
			}
		}
	}
	
	private void actionDevice() {
		deviceId = ++deviceId % 4;
		device.setIcon(deviceIcons[deviceId]);
		source.setOrientation(deviceId);
		xyViewer.setInOut();
	}

	
	private void actionClear() {
		int pid = signal.getPersonId();
		int did = signal.getDeviceId();
		signal.clear();
		signal.setPersonId(pid);
		signal.setDeviceId(did);
		timeZero = -1;
		signalIndex = 0;
		repaint();
	}
	
	private void actionSaveSig() {
		signal.removeDuplicates();
		signal.trim();
		Vector s = signal.getSignalVector();
		try {
			FileWriter fw = new FileWriter("test.dat");
			for (int i = 0; i < s.size(); ++i) {
				int[] t = (int[]) s.elementAt(i);
				int x = t[HWSignal.AXIS_X];
				int y = t[HWSignal.AXIS_Y];
				int p = t[HWSignal.AXIS_P];
				int ms = t[HWSignal.AXIS_TIME];
				if (this.timeZero == -1) this.timeZero = ms;
				ms -= timeZero;
				fw.write("" + x + ',' + y + ',' + p + ',' + ms + '\n');
			}
			fw.close();
		} catch (Exception e) {
			System.out.println(e);
		}
		signal.notifyConsumers(true);
		//signal.clear();
//		actionClear();
//		repaint();
		dispose();
	}
	
	public void update() {
//		if (!isInfinite) return;
//		Vector v = this.signal.getSignalVector();
//		for (; v != null && this.signalIndex < v.size(); ++this.signalIndex) {
//			int[] s = (int[]) v.elementAt(signalIndex);
//			int x = s[HWSignal.AXIS_X];
//			int y = s[HWSignal.AXIS_Y];
//			int p = s[HWSignal.AXIS_P];
//			int t = s[HWSignal.AXIS_TIME];
//			if (this.timeZero == -1) this.timeZero = t;
//			t -= timeZero;
//			System.out.println("" + x + ',' + y + ',' + p + ',' + t);
//		}
	}
	

	public void reload() {}
	
	public void itemStateChanged(ItemEvent e) {
	}

}
