/*
 * Created on 01.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.amsl.hw;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HWMouseSignal extends Thread implements HWSignalSource, MouseListener, MouseMotionListener {
	
	private HWSignal  signal;
	private int button = 0;
	private int time0;
	private int timeT;
	private int timeout;
	private boolean ready = false;

	private boolean[] axisAvailable = { true, true, true, false, false, true, true };
	
	public HWMouseSignal(HWSignal s) {
		signal = s;
		signal.setGapPressure(0);
		signal.setSignalSource(this);
		time0 = (int) (System.nanoTime() / 1000000);
		timeT = Integer.MAX_VALUE;
	}
	
	public void run() {
		try {
			while (System.nanoTime() / 1000000 - timeT - time0 < timeout) sleep(100);
		} catch (Throwable e) {}
		ready = true;
	}
	
	public boolean isStream() {	return true; }
	public boolean isReady() { return ready; }
	public void setPanelParameters(int xMin, int yMin, int width, int height) {}

	public void halt() {}
	public void setTimeout(int t) { timeout = t; }

	public boolean axisAvailable(int a) {
		return axisAvailable[a];
	}
	
	public int getMaxWidth() {
		return (int) Toolkit.getDefaultToolkit().getScreenSize().getWidth();
	}
	public int getMaxHeight() {
		return (int) Toolkit.getDefaultToolkit().getScreenSize().getHeight();
	}

	public void mouseClicked(MouseEvent  e) {}
	public void mouseEntered(MouseEvent  e) {}
	public void mouseExited(MouseEvent   e) {}
	public void mouseMoved(MouseEvent    e) {}
	public void mouseReleased(MouseEvent e) { generateSample(e.getX(), e.getY(), 0); }
	public void mouseDragged(MouseEvent  e) { generateSample(e.getX(), e.getY(), button); }
	public void mousePressed(MouseEvent  e) { button = e.getButton(); generateSample(e.getX(), e.getY(), button = e.getButton()); }
	
	private void generateSample(int x, int y, int b) {
		//System.out.println("" + x + " " + y);
		int[] sample = new int[HWSignal.AXES_NUMBER];
		sample[HWSignal.AXIS_X]       = x;
		sample[HWSignal.AXIS_Y]       = y;
		sample[HWSignal.AXIS_P]       = b != 0 ? 1 : 0;
		sample[HWSignal.AXIS_BUTTONS] = b;
		sample[HWSignal.AXIS_TIME]    = timeT = (int) (System.nanoTime() / 1000000) - time0;
		signal.addSample(sample);
		signal.notifyConsumers(false);
	}

	public void setTabletOffsetAndSize(int x, int y, int w, int h) {}
	
	public String getType() {
		return "Mouse mode";
	}

}
