/*
 * Created on 27.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/*
 * TODO: drop, trim und co waehrend addSample()...
 * levenshtein auslagern
 * fft implementieren (eventuell auch auslagern)
 */
package org.amsl.hw;

import java.util.*;

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HWSignal {

	public static final int AXIS_X        = 0;
	public static final int AXIS_Y        = 1;
	public static final int AXIS_BUTTONS  = 2;
	public static final int AXIS_AZIMUTH  = 3;
	public static final int AXIS_ALTITUDE = 4;
	public static final int AXIS_P        = 5;
	public static final int AXIS_TIME     = 6;

	public static final int AXES_NUMBER   = 7;

	
	private Vector         signalVector;
	private int            gapPressure;
	
	private HWSignalSource source;
	private Vector         consumers;
	private boolean        ready;
	
	private int            sampleId    = -1;
	private int            deviceId    = -1;
	private int            personId    = -1;
	private String         description = null;
	private String         background  = null;
	private String         audioFile   = null;

	private boolean[]      axisAvailable = { true, true, true, false, false, true, true };
	private int[]          axisMin = new int[AXES_NUMBER];
	private int[]          axisMax = new int[AXES_NUMBER];

	public HWSignal() {
		consumers    = new Vector();
		signalVector = new Vector();
		gapPressure  = 0;
		initMinMax();
	}

	/**
	 * Creates a new HWSignal as a duplicate of another one.
	 */
	public HWSignal(HWSignal s) {
		consumers = new Vector();
		Vector v = s.getSignalVector();
		int l = v.size();
		signalVector = new Vector(l);
		initMinMax();
		for (int i = 0; i < l; ++i) {
			int[] s1 = (int[]) v.elementAt(i);
			int[] s2 = new int[HWSignal.AXES_NUMBER];
			for (int j = 0; j < HWSignal.AXES_NUMBER; ++j) s2[j] = s1[j];
			signalVector.add(s2);
			minMax(s2);
		}
		gapPressure  = s.getGapPressure();
	}
	
	/**
	 * Creates a new HWSignal from a set of sub-signals. (concatenation)
	 * 
	 * @param s is an array of 
	 */
	public HWSignal(HWSignal[] s, boolean insertGaps) {
		consumers    = new Vector();
		signalVector = new Vector();
		initMinMax();
		for (int j = 0; j < s.length; ++j) {
			if (insertGaps && j > 0) {
				int[] gap = new int[HWSignal.AXES_NUMBER];
				gap[HWSignal.AXIS_P] = 0;
				int t = ((int[]) signalVector.elementAt(signalVector.size() - 1))[HWSignal.AXIS_TIME] + 1;
				gap[HWSignal.AXIS_TIME] = t;
				signalVector.add(gap);
			}
			Vector v = s[j].getSignalVector();
			for (int i = 0, l = v.size(); i < l; ++i) {
				int[] s1 = (int[]) v.elementAt(i);
				int[] s2 = new int[HWSignal.AXES_NUMBER];
				for (int k = 0; k < HWSignal.AXES_NUMBER; ++k) s2[k] = s1[k];
				signalVector.add(s2);
				minMax(s2);
			}
			gapPressure = s[j].getGapPressure();
		}
	}
	
	private void initMinMax() {
		for (int i = 0; i < AXES_NUMBER; ++i) {
			axisMin[i] = Integer.MAX_VALUE;
			axisMax[i] = Integer.MIN_VALUE;
		}
	}
	
	public void clear() {
		signalVector.clear();
		initMinMax();
		audioFile = null;
		sampleId = deviceId = personId = -1;
		notifyConsumers(true);
	}

	private void minMax(int[] s) {
		for (int i = 0; i < AXES_NUMBER; ++i) {
			axisMin[i] = s[i] < axisMin[i] ? s[i] : axisMin[i];
			axisMax[i] = s[i] > axisMax[i] ? s[i] : axisMax[i];
		}
	}
	
	public boolean axisAvailable(int a) {
		return false;
	}
	
	public boolean isReady() {
		return ready;
	}
	
	public boolean isEmpty() {
		return signalVector.isEmpty();
	}

	public Vector getSignalVector() {
		return signalVector;
	}
	
	public HWSignalSource getSignalSource() {
		return source;
	}
	public void setSignalSource(HWSignalSource s) {
		source = s;
	}

	public int getGapPressure() {
		return gapPressure;
	}
	public void setGapPressure(int g) {
		gapPressure = g;
	}
	
	public int[] getBoundingBox() {
		int[] result = {axisMin[AXIS_X], axisMin[AXIS_Y], axisMax[AXIS_X], axisMax[AXIS_Y] };
		return result;
	}
	
	public void addSample(int[] s) {
		//System.out.println("" + this + " " + signalVector.size() + " " + s[0] + " " + s[1]);
		signalVector.add(s);
		minMax(s);
	}
	
	public void addConsumer(HWSignalConsumer c) {
		consumers.add(c);
	}
	public void removeConsumer(HWSignalConsumer c) {
		consumers.remove(c);
	}

	public void notifyConsumers(boolean reload) {
		for (int i = 0, l = consumers.size(); i < l; ++i)
			if (reload) ((HWSignalConsumer) consumers.elementAt(i)).reload();
			else ((HWSignalConsumer) consumers.elementAt(i)).update();
	}
	
	public int getDeviceId()             { return deviceId; }
	public void setDeviceId(int i)       { deviceId = i; }
	public int getPersonId()             { return personId; }
	public void setPersonId(int i)       { personId = i; }
	public int getSampleId()             { return sampleId; }
	public void setSampleId(int i)       { sampleId = i; }
	public String getDescription()       { return description; }
	public void setDescription(String d) { description = d; }
	public String getBackground()        { return background; }
	public void setBackground(String b)  { background = b; }
	public String getAudioFile()         { return audioFile; }
	public void setAudioFile(String a)   { audioFile = a; }
	
	/**
	 * the sample comment will be null is most cases. it can contain an id within the
	 * origin source (e.g. platasign sample_id)
	 */
	public String getSampleComment() {
		return null;
	}
	
	/**
	 * Removes no-pressure-periods at beginning and end of signal.
	 * Replaces sets of belonging no-pressure sample points with special single sample (x=-1, y=-1, ...)
	 */
	public void trim() {
		ready = false;
		initMinMax();
		Vector _tmp = new Vector(signalVector);
		signalVector.clear();
		boolean gap = true;
		for (int i = 0, l = _tmp.size(); i < l; ++i) {
			int[] s = (int[]) _tmp.elementAt(i);
			if (s[HWSignal.AXIS_P] <= gapPressure) {
				if (gap) continue;
				gap = true;
				s[HWSignal.AXIS_X] = s[HWSignal.AXIS_Y] =
					s[HWSignal.AXIS_P] = s[HWSignal.AXIS_AZIMUTH] =
					s[HWSignal.AXIS_ALTITUDE] = s[HWSignal.AXIS_X] = -1;
				signalVector.add(s);
			} else {
				signalVector.add(s);
				gap = false;
				minMax(s);
			}
		}
		if (gap) signalVector.removeElementAt(signalVector.size() - 1);
		ready = true;
	}
	
	/**
	 * Removes successive sample points with with the same coordinate.
	 */
	public void removeDuplicates() {
		ready = false;
		initMinMax();
		Vector _tmp = new Vector(signalVector);
		signalVector.clear();
		boolean start = true;
		for (int i = 0, j = 1, l = _tmp.size(); j < l; ++j) {
			int[] s1 = (int[]) _tmp.elementAt(i);
			if (start) {
				start = false;
				signalVector.add(s1);
				minMax(s1);
			}
			int[] s2 = (int[]) _tmp.elementAt(j);
			if (s1[HWSignal.AXIS_X] == s2[HWSignal.AXIS_X] && s1[HWSignal.AXIS_Y] == s2[HWSignal.AXIS_Y]) continue;
			signalVector.add(s2);
			minMax(s2);
			i = j;
		}
		ready = true;
	}
		
	/**
	 * Moves bounding box into cordinate origin. If width>0 and/or height>0, coordinates are shrinked...
	 */
	public void normalize(int width, int height) {
		ready = false;
		int xMin = Integer.MAX_VALUE;
		int yMin = Integer.MAX_VALUE;
		int xMax = Integer.MIN_VALUE;
		int yMax = Integer.MIN_VALUE;
		for (int i = 0, l = signalVector.size(); i < l; ++i) {
			int[] s = (int[]) signalVector.elementAt(i);
			if (s[HWSignal.AXIS_X] == -1) continue;
			xMin = xMin < s[HWSignal.AXIS_X] ? xMin : s[HWSignal.AXIS_X];
			yMin = yMin < s[HWSignal.AXIS_Y] ? yMin : s[HWSignal.AXIS_Y];
			xMax = xMax > s[HWSignal.AXIS_X] ? xMax : s[HWSignal.AXIS_X];
			yMax = yMax > s[HWSignal.AXIS_Y] ? yMax : s[HWSignal.AXIS_Y];
		}
		double xScale = width  > 0 && (xMax - xMin) > 0 ? (double) width / (xMax - xMin) : 1;
		double yScale = height > 0 && (yMax - yMin) > 0 ? (double) width / (yMax - yMin) : xScale;
		for (int i = 0, l = signalVector.size(); i < l; ++i) {
			int[] s = (int[]) signalVector.elementAt(i);
			if (s[HWSignal.AXIS_X] == -1) continue;
			s[HWSignal.AXIS_X] -= xMin;
			s[HWSignal.AXIS_Y] -= yMin;
			s[HWSignal.AXIS_X] *= xScale;
			s[HWSignal.AXIS_Y] *= yScale;
		}
		ready = true;
	}

	/**
	 * Splits the signal a its gap positions (and removes the gaps)
	 * 
	 * @return an array of signals
	 */
	public HWSignal[] split() {
		Vector   result = new Vector();
		HWSignal sig    = new HWSignal();
		boolean  done   = false;
		result.add(sig);

		for (int i = 0, l = signalVector.size(); i < l; ++i) {
			int[] s = (int[]) signalVector.elementAt(i);
			if (s[HWSignal.AXIS_P] > gapPressure) {
				sig.addSample(s);
				done = true;
			} else {
				sig = new HWSignal();
				result.add(sig);
			}
		}
		if (!done) return null;
		HWSignal[] res = new HWSignal[result.size()];
		for (int i = 0; i < res.length; ++i) res[i] = (HWSignal) result.elementAt(i);
		return res;
	}
	
	/**
	 * Sort the sampled values of the signal regarding their timestamp
	 */
	public void sort() {
		Object[] a = signalVector.toArray(); 
		Arrays.sort(a, new Comparator() {
			public int compare(Object o1, Object o2) {
				return ((int[]) o1)[AXIS_TIME] - ((int[]) o2)[AXIS_TIME];
			}
		});
		signalVector = new Vector(a.length);
		for (int i = 0; i < a.length; ++i) signalVector.add(a[i]);
	}
	
//	public HWLevenshteinPoint[] levenshteinPoints() {
//		Vector result = new Vector();
//		for (int i = 0, l = signalVector.size(); i < l; ++i) {
//			int[] s = (int[]) signalVector.elementAt(i);
//			if (s[HWSignal.AXIS_P] <= gapPressure) result.add(new HWLevenshteinPoint(HWLevenshteinPoint.LEV_GAP));
//		}
//		HWLevenshteinPoint[] res = new HWLevenshteinPoint[result.size()];
//		if (result.size() == 0) return null;
//		for (int i = 0; i < res.length; ++i) res[i] = (HWLevenshteinPoint) result.elementAt(i);
//		return res;
//	}
	
	public void addNoise() {
		for (int i = 0, l = signalVector.size(); i < l; ++i) {
			int[] s = (int[]) signalVector.elementAt(i);
			if (s[HWSignal.AXIS_P] <= gapPressure) continue;
			s[HWSignal.AXIS_X] += Math.sin(s[HWSignal.AXIS_TIME]/5.) * 30;
			s[HWSignal.AXIS_Y] += Math.cos(s[HWSignal.AXIS_TIME]/5.) * 30;
		}
	}
	
	public String toString() {
		//if (true) return "" + signalVector.size();
		StringBuffer result = new StringBuffer();
		for (int i = 0, l = signalVector.size(); i < l; ++i) {
			int[] sample = (int[]) signalVector.elementAt(i);
			result.append(i);
			for (int j = 0; j < AXES_NUMBER; ++j) {
				result.append('\t');
				result.append(sample[j]);
			}
			result.append('\n');
		}
		for (int i = 0; i < AXES_NUMBER; ++i) {
			result.append(axisMin[i]);
			result.append('-');
			result.append(axisMax[i]);
			result.append(' ');
		}
		result.append('\n');
		return result.toString();
		}

}
